/*!!
 * Matomo - free/libre analytics platform
 *
 * Matomo Tag Manager
 *
 * @link https://matomo.org
 * @source https://github.com/matomo-org/tag-manager/blob/master/js/piwik.js
 * @license https://matomo.org/free-software/bsd/ BSD-3 Clause (also in js/LICENSE.txt)
 */
(function(){var b=document;var a=window;
/*!!! previewModeHook */
;if(typeof window.MatomoTagManager!=="object"){if(typeof window._mtm!=="object"){window._mtm=[]}window.MatomoTagManager=(function(){var k=new Date().getTime();function j(){if(window.mtmPreviewWindow&&"object"===typeof window.mtmPreviewWindow.mtmLogs){var G=new Date();var I=[];for(var H=0;H<arguments.length;H++){I.push(JSON.stringify(arguments[H],function(i,J){if(typeof J==="object"&&J instanceof Node){return J.nodeName}else{return J}}))}window.mtmPreviewWindow.mtmLogs.push({time:G.toLocaleTimeString()+"."+G.getMilliseconds(),messages:I})}}function d(G){if(window.mtmPreviewWindow&&"object"===typeof window.mtmPreviewWindow.mtmEvents&&G){var i=new Date();G.time=i.toLocaleTimeString()+"."+i.getMilliseconds();
window.mtmPreviewWindow.mtmEvents.push(G)}}var y={enabled:!!window.mtmPreviewWindow,log:function(){j.apply(a,arguments);if(this.enabled&&"undefined"!==typeof console&&console&&console.debug){console.debug.apply(console,arguments)}},error:function(){j.apply(a,arguments);if("undefined"!==typeof console&&console&&console.error){console.error.apply(console,arguments)}}};function C(i){y.error(i);if(typeof l!=="object"||l.THROW_ERRORS){throw new Error(i)}}function u(H,J){if(B.isString(H)&&H.indexOf(".")!==-1){var I=H.split(".");var G;for(G=0;G<I.length;G++){if(I[G] in J){J=J[I[G]]}else{return}}return J}}function F(K){var J="mtm:";var G={};function I(N){return K in a&&B.isObject(a[K])}function M(N){return I()&&B.isFunction(a[K][N])}function L(P,N){if(M("setItem")){try{a[K].setItem(J+P,JSON.stringify(N))}catch(O){}}else{G[P]=N}}function H(P){if(M("getItem")){try{var N=a[K].getItem(J+P);if(N){N=JSON.parse(N);if(B.isObject(N)){return N}}}catch(O){}return{}}else{if(P in G){return G[P]}}}function i(O){if(M("removeItem")){try{a[K].removeItem(J+O)
}catch(N){}}else{if(O in G){delete G[O]}}}this.set=function(R,O,S,N){var P=null;if(N){P=(new Date().getTime())+(parseInt(N,10)*1000)}var Q=H(R);Q[O]={value:S,expire:P};L(R,Q)};this.get=function(P,N){var O=H(P);if(O&&N in O&&"value" in O[N]){if(O[N].expire&&O[N].expire<(new Date().getTime())){delete O[N];L(P);return}return O[N].value}};this.clearAll=function(){G={};if(I()&&B.isFunction(Object.keys)){var N=Object.keys(a[K]);if(N){for(var O=0;O<N.length;O++){if(String(N[O]).substr(0,J.length)===J){i(String(N[O]).substr(J.length))}}}}}}var x=new F("localStorage");var e=new F("sessionStorage");var B={_compare:function(J,G,I){var H=["equals","starts_with","contains","ends_with"];if(this.indexOfArray(H,I)!==-1){J=String(J).toLowerCase();G=String(G).toLowerCase()}switch(I){case"equals":return String(J)===String(G);case"equals_exactly":return String(J)===String(G);case"regexp":return null!==(String(J).match(new RegExp(G)));case"regexp_ignore_case":return null!==(String(J).match(new RegExp(G,"i")));
case"lower_than":return J<G;case"lower_than_or_equals":return J<=G;case"greater_than":return J>G;case"greater_than_or_equals":return J>=G;case"contains":return String(J).indexOf(G)!==-1;case"match_css_selector":if(!G||!J){return false}var i=A.bySelector(G);return B.indexOfArray(i,J)!==-1;case"starts_with":return String(J).indexOf(G)===0;case"ends_with":return String(J).substring(J.length-G.length,J.length)===G}return false},compare:function(J,G,H){var I=String(H).indexOf("not_")===0;if(I){H=String(H).substr("not_".length)}var i=this._compare(J,G,H);if(I){return !i}return i},trim:function(i){if(i&&String(i)===i){return i.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")}return i},isDefined:function(G){var i=typeof G;return i!=="undefined"},isFunction:function(i){return typeof i==="function"},isObject:function(i){return typeof i==="object"&&i!==null},isString:function(i){return typeof i==="string"},isNumber:function(i){return typeof i==="number"},isArray:function(G){if(!B.isObject(G)){return false
}if("function"===typeof Array.isArray&&Array.isArray){return Array.isArray(G)}var H=Object.prototype.toString;var i=H.call([]);return H.call(G)===i},hasProperty:function(i,G){return Object.prototype.hasOwnProperty.call(i,G)},indexOfArray:function(I,H){if(!I){return -1}if("function"===typeof I.indexOf&&I.indexOf){return I.indexOf(H)}if(!this.isArray(I)){return -1}for(var G=0;G<I.length;G++){if(I[G]===H){return G}}return -1},setMethodWrapIfNeeded:function(G,H,J){if(!(H in G)){G[H]=J;return}var I=G[H];if(!l.utils.isFunction(I)){G[H]=J;return}try{G[H]=function(){try{var K=I.apply(G,[].slice.call(arguments,0))}catch(L){J.apply(G,[].slice.call(arguments,0));throw L}J.apply(G,[].slice.call(arguments,0));return K}}catch(i){}}};var t=function(){this.values={};this.events=[];this.callbacks=[];this.reset=function(){this.values={};this.events=[];this.callbacks=[]};this.push=function(H){if(!B.isObject(H)){y.log("pushed dataLayer value is not an object",H);return}this.events.push(H);var G;for(G in H){if(B.hasProperty(H,G)){this.set(G,H[G])
}}for(G=0;G<this.callbacks.length;G++){if(this.callbacks[G]){this.callbacks[G](H)}}};this.on=function(i){this.callbacks.push(i);return this.callbacks.length-1};this.off=function(i){if(i in this.callbacks){this.callbacks[i]=null}};this.set=function(i,G){this.values[i]=G};this.getAllEvents=function(i){return this.events};this.get=function(i){if(i in this.values){if(B.isFunction(this.values[i])){return this.values[i]()}else{if(B.isObject(this.values[i])&&B.isFunction(this.values[i].get)){return this.values[i].get()}}return this.values[i]}var G=u(i,this.values);if(B.isDefined(G)){return G}}};var p=new t();var E={matchesDateRange:function(H,G,I){var J=H.getTime()+(H.getTimezoneOffset()*60000);if(G){G=String(G).replace(/-/g,"/")}if(I){I=String(I).replace(/-/g,"/")}var L,i;try{L=new Date(G)}catch(K){if(G){C("Invalid startDateTime given")}}try{i=new Date(I)}catch(K){if(I){C("Invalid startDateTime given")}}if(G&&isNaN&&isNaN(L.getTime())){C("Invalid startDateTime given")}if(I&&isNaN&&isNaN(i.getTime())){C("Invalid endDateTime given")
}if(G&&J<(L.getTime()+(L.getTimezoneOffset()*60000))){return false}if(I&&J>(i.getTime()+(i.getTimezoneOffset()*60000))){return false}return true}};var r={parseUrl:function(i,J){try{var K=document.createElement("a");K.href=i;var G=K.href;K=document.createElement("a");K.href=G;if(J&&J in K){if("hash"===J){return String(K[J]).replace("#","")}else{if("protocol"===J){return String(K[J]).replace(":","")}else{if("search"===J){return String(K[J]).replace("?","")}else{if("port"===J&&!K[J]){if(K.protocol==="https:"){return"443"}else{if(K.protocol==="http:"){return"80"}}}}}}if("pathname"===J&&K[J]&&String(K[J]).substr(0,1)!=="/"){return"/"+K[J]}if("port"===J&&K[J]){return String(K[J])}return K[J]}if("origin"===J&&"protocol" in K&&K.protocol){return K.protocol+"//"+K.hostname+(K.port?":"+K.port:"")}return}catch(I){if("function"===typeof URL){var H=new URL(i);if(J&&J in H){if("hash"===J){return String(H[J]).replace("#","")}else{if("protocol"===J){return String(H[J]).replace(":","")}else{if("search"===J){return String(H[J]).replace("?","")
}else{if("port"===J&&!H[J]){if(H.protocol==="https:"){return 443}else{if(H.protocol==="http:"){return 80}}}}}}return H[J]}return}}},decodeSafe:function(G){try{return a.decodeURIComponent(G)}catch(i){return a.unescape(G)}},getQueryParameter:function(K,G){if(!B.isDefined(G)){G=a.location.search}if(!G||!B.isDefined(K)||K===null||K===false||K===""){return null}var i=G.substr(0,1);if(G!=="?"&&G!=="&"){G="?"+G}K=K.replace("[","\\[");K=K.replace("]","\\]");var J=new RegExp("[?&]"+K+"(=([^&#]*)|&|#|$)");var I=J.exec(G);if(!I){return null}if(!I[2]){return""}var H=I[2].replace(/\+/g," ");return this.decodeSafe(H)}};var c;var D={hasSetupScroll:false,scrollCallbacks:[],scrollListenEvents:["scroll","resize"],offScroll:function(G){if(G in this.scrollCallbacks){this.scrollCallbacks[G]=null}var I=0,H=0;for(I in this.scrollCallbacks){if(this.scrollCallbacks[I]){H++}}if(!H){for(I=0;I<this.scrollListenEvents.length;I++){if(b.removeEventListener){a.removeEventListener(this.scrollListenEvents[I],this.didScroll,true)
}else{a.detachEvent("on"+this.scrollListenEvents[I],this.didScroll)}}this.hasSetupScroll=false}},didScroll:function(i){if(c){return}if(i&&i.type&&i.type==="scroll"&&i.target&&i.target!==b&&i.target!==a){return}c=setTimeout(function(){c=null;var G;for(G=0;G<D.scrollCallbacks.length;G++){if(D.scrollCallbacks[G]){D.scrollCallbacks[G](i)}}},120)},onScroll:function(G){this.scrollCallbacks.push(G);if(!this.hasSetupScroll){this.hasSetupScroll=true;var i=0;for(i=0;i<this.scrollListenEvents.length;i++){if(b.addEventListener){a.addEventListener(this.scrollListenEvents[i],this.didScroll,true)}else{a.attachEvent("on"+this.scrollListenEvents[i],this.didScroll)}}}return this.scrollCallbacks.length-1},getScreenHeight:function(){return a.screen.height},getScreenWidth:function(){return a.screen.width},getViewportWidth:function(){var i=a.innerWidth||b.documentElement.clientWidth||b.body.clientWidth;if(!i){return 0}return i},getViewportHeight:function(){var i=a.innerHeight||b.documentElement.clientHeight||b.body.clientHeight;
if(!i){return 0}return i},getPerformanceTiming:function(i){if("performance" in a&&B.isObject(a.performance)&&B.isObject(a.performance.timing)&&i in a.performance.timing){return a.performance.timing[i]}return 0}};var A={loadScriptUrl:function(H,G){if(!G){G={}}if(!B.isDefined(G.defer)){G.defer=true}if(!B.isDefined(G.async)){G.async=true}if(!B.isDefined(G.type)){G.type="text/javascript"}var i=document.createElement("script");i.src=H;i.type=G.type;i.defer=!!G.defer;i.async=!!G.async;if(B.isFunction(G.onload)){i.onload=G.onload}if(B.isFunction(G.onerror)){i.onerror=G.onerror}if(B.isDefined(G.charset)){i.charset=G.charset}if(B.isDefined(G.id)){i.id=G.id}b.head.appendChild(i)},getScrollLeft:function(){return a.document.body.scrollLeft||a.document.documentElement.scrollLeft},getScrollTop:function(){return a.document.body.scrollTop||a.document.documentElement.scrollTop},getDocumentHeight:function(){return Math.max(b.body.offsetHeight,b.body.scrollHeight,b.documentElement.offsetHeight,b.documentElement.clientHeight,b.documentElement.scrollHeight,1)
},getDocumentWidth:function(){return Math.max(b.body.offsetWidth,b.body.scrollWidth,b.documentElement.offsetWidth,b.documentElement.clientWidth,b.documentElement.scrollWidth,1)},addEventListener:function(I,H,G,i){if(!I){y.log("element not found, cannot add event listener",I,this);return}if(I.addEventListener){i=i||false;I.addEventListener(H,G,i);return true}if(I.attachEvent){return I.attachEvent("on"+H,G)}I["on"+H]=G},getElementText:function(G){if(!G){return}var i=G.innerText||G.textContent||"";i=i.replace(/([\s\uFEFF\xA0])+/g," ");i=i.replace(/(\s)+/g," ");return B.trim(i)},getElementClassNames:function(i){if(i&&i.className){return B.trim(String(i.className).replace(/\s{2,}/g," "))}return""},getElementAttribute:function(H,i){if(H&&H.getAttribute){return H.getAttribute(i)}if(!H||!H.attributes){return}var G=(typeof H.attributes[i]);if("undefined"===G){return null}if(H.attributes[i].value){return H.attributes[i].value}if(H.attributes[i].nodeValue){return H.attributes[i].nodeValue}return null
},_htmlCollectionToArray:function(H){var i=[];if(!H||!H.length){return i}var G;for(G=0;G<H.length;G++){i.push(H[G])}return i},byId:function(i){if(B.isString(i)&&i.substr(0,1)==="#"){i=i.substr(1)}return b.getElementById(i)},byClassName:function(i){if(i&&"getElementsByClassName" in b){return this._htmlCollectionToArray(b.getElementsByClassName(i))}return[]},byTagName:function(i){if(i&&"getElementsByTagName" in b){return this._htmlCollectionToArray(b.getElementsByTagName(i))}return[]},bySelector:function(i){if(i&&"querySelectorAll" in b){return this._htmlCollectionToArray(b.querySelectorAll(i))}return[]},isElementContext:function(I,i){if(!I||!i){return false}I=String(I).toLowerCase();i=String(i).toLowerCase();var H=I.lastIndexOf("<"+i);if(H===-1){return false}var G=I.substring(H);return !G.match(new RegExp("<\\s*/\\s*"+i+">"))},isAttributeContext:function(M,K){if(!M||!K){return false}M=String(M).replace(/([\s\uFEFF\xA0]*=[\s\uFEFF\xA0]*)/g,"=");var H=M.lastIndexOf("<");if(H===-1){return false
}var O=M.substring(H);var G=O.indexOf(">");if(G!==-1){return false}var N=O.lastIndexOf("=");if(N===-1){return false}var J=O.lastIndexOf(" ",N);var L=O.substring(J,N);L=B.trim(L);if(L.toLowerCase()!==K.toLowerCase()){return false}var I=O.substring(N).replace("=","");var i=I.substring(0,1);if('"'===i){return -1===I.substring(1).indexOf('"')}else{if("'"===i){return -1===I.substring(1).indexOf("'")}}return -1===I.indexOf(" ")},onLoad:function(i){if(b.readyState==="complete"){i()}else{if(a.addEventListener){a.addEventListener("load",i)}else{if(a.attachEvent){a.attachEvent("onload",i)}}}},onReady:function(H){var i=false;if(b.attachEvent){i=b.readyState==="complete"}else{i=b.readyState!=="loading"}if(i){H();return}if(b.addEventListener){this.addEventListener(b,"DOMContentLoaded",function G(){b.removeEventListener("DOMContentLoaded",G,false);if(!i){i=true;H()}})}else{if(b.attachEvent){b.attachEvent("onreadystatechange",function G(){if(b.readyState==="complete"){b.detachEvent("onreadystatechange",G);
if(!i){i=true;H()}}})}}this.onLoad(function(){if(!i){i=true;H()}})},onClick:function(G,i){if(typeof i==="undefined"){i=b.body}l.dom.addEventListener(i,"click",function(H){var I=(H.which?H.which:1);if(I===1){G(H,"left")}},true);l.dom.addEventListener(i,"auxclick",function(H){var I=(H.which?H.which:2);if(I===2){G(H,"middle")}},true);l.dom.addEventListener(i,"contextmenu",function(H){var I=(H.which?H.which:3);if(I===3){G(H,"right")}},true)}};function w(H){this.window=a;this.document=b;this.set=function(i,I){this[i]=I};this.get=function(I,i){if(I===null||I===false||!B.isDefined(I)){return i}if(I in this){if(B.isObject(this[I])&&"get" in this[I]&&B.isFunction(this[I].get)){return this[I].get()}return this[I]}var J=u(I,this);if(B.isDefined(J)){return J}return i};this.buildVariable=function(i){return o(i,this.get("container"))};if(B.isObject(H)){for(var G in H){if(B.hasProperty(H,G)){this.set(G,H[G])}}}}function z(G,i){this.isValid=function(){var I=o(G.actual,i).get();var H=o(G.expected,i).get();
return B.compare(I,H,G.comparison)}}function o(G,i){if(B.isObject(G)&&G.joinedVariable&&B.isArray(G.joinedVariable)){return new q(G.joinedVariable,i)}else{if(B.isObject(G)&&G.type){return new s(G,i)}}return new m(G,i)}function q(G,i){this.name="";this.type="JoinedVariable";this.getDefinition=function(){return G};this.get=function(){var I="",J;for(var H=0;H<G.length;H++){J=o(G[H],i).toString();if(J!==false&&J!==null&&B.isDefined(J)){I+=J}}return I};this.toString=function(){return this.get()};this.addDebugValues=function(H){H.push({name:null,type:"_joined",value:this.get()})}}function m(I,G){this.name="";this.type="ConstantVariable";this.getDefinition=function(){return I};function H(K){return K&&B.isObject(K)&&!B.isArray(K)&&(B.hasProperty(K,"type")||B.hasProperty(K,"joinedVariable"))}function J(M){if(M==null||typeof M!=="object"){return M}var K=new M.constructor();var L;for(L in M){if(B.hasProperty(M,L)){K[L]=J(M[L])}}return K}function i(L){var K;if(H(L)){L=o(L,G).get()}else{if(L&&B.isArray(L)){for(K=0;
K<L.length;K++){L[K]=i(L[K])}}else{if(L&&B.isObject(L)){for(K in L){if(B.hasProperty(L,K)){L[K]=i(L[K])}}}}}return L}this.get=function(){var K=I;if(B.isObject(K)){K=J(K);K=i(K)}return K};this.toString=function(){return I};this.addDebugValues=function(K){K.push({name:null,type:"_constant",value:this.get()})}}function s(H,G){this.type=H.type;this.name=H.name;this.lookUpTable=H.lookUpTable||[];this.defaultValue=undefined;this.parameters=H.parameters||{};this.getDefinition=function(){return H};this.get=function(){var L;try{L=this.theVariable.get()}catch(M){y.error("Failed to get value of variable",M,this);L=undefined}if((!B.isDefined(L)||L===null||L===false)&&B.isDefined(this.defaultValue)){L=this.defaultValue}var K;for(K=0;K<this.lookUpTable.length;K++){var N=this.lookUpTable[K];if(B.compare(L,N.matchValue,N.comparison)){return N.outValue}}return L};this.toString=function(){if(this.theVariable&&B.hasProperty(this.theVariable,"toString")&&B.isFunction(this.theVariable.toString)){try{return this.theVariable.toString()
}catch(i){y.error("Failed to get toString of variable",i,this);return}}return this.get()};this.addDebugValues=function(i){i.push({name:this.name,type:this.type,value:this.get()})};if("undefined"!==typeof H.defaultValue){this.defaultValue=H.defaultValue}if(!B.isDefined(H.Variable)||!H.Variable){y.log("no template defined for variable ",H);return}var I,J=new w({variable:this,container:G});if(B.isObject(H.parameters)){for(I in H.parameters){if(B.hasProperty(H.parameters,I)){J.set(I,o(H.parameters[I],G))}}}if(B.isFunction(H.Variable)){this.theVariable=new H.Variable(J,l)}else{if(B.isObject(H.Variable)){this.theVariable=H.Variable}else{if(H.Variable in G.templates){this.theVariable=new G.templates[H.Variable](J,l)}else{C("No matching variable template found")}}}}function f(I,G){this.referencedTags=[];this.id=I.id;this.type=I.type;this.name=I.name;this.conditions=[];this.parameters=I.parameters||{};var H=this;this.getId=function(){return this.id};this.setUp=function(){if(this.theTrigger&&this.theTrigger.setUp&&B.isFunction(this.theTrigger.setUp)){this.theTrigger.setUp(function(P){p.push(P);
if(!("event" in P)){return}var L={tags:[],variables:[],metTrigger:null,name:P.event,eventData:P,container:{}};var O,N;if(H.meetsConditions()){y.log("The condition is met for trigger "+H.name,H);L.metTrigger={name:H.name,type:H.type};var M=H.getReferencedTags();for(N=0;N<M.length;N++){if(M[N].hasBlockTrigger(H)){M[N].block();M[N].addDebugValues(L.tags,"Block")}else{if(M[N].hasFireTrigger(H)){M[N].fire();M[N].addDebugValues(L.tags,"Fire")}}}}if(window.mtmPreviewWindow||y.enabled){G.addDebugValues(L.container);d(L);if(y.enabled){y.log("event: ",L)}}})}};this.addReferencedTag=function(i){this.referencedTags.push(i)};this.getReferencedTags=function(){return this.referencedTags};this.meetsConditions=function(){var L,M;for(L=0;L<this.conditions.length;L++){M=new z(this.conditions[L],G);if(!M.isValid()){return false}}return true};if(I.conditions&&B.isArray(I.conditions)){this.conditions=I.conditions}var J,K=new w({trigger:this,container:G});if(B.isObject(I.parameters)){for(J in I.parameters){if(B.hasProperty(I.parameters,J)){K.set(J,o(I.parameters[J],G))
}}}if(!B.isDefined(I.Trigger)||!I.Trigger){y.error("no template defined for trigger ",I);return}if(B.isFunction(I.Trigger)){this.theTrigger=new I.Trigger(K,l)}else{if(B.isObject(I.Trigger)){this.theTrigger=I.Trigger}else{if(I.Trigger in G.templates){this.theTrigger=new G.templates[I.Trigger](K,l)}else{C("No matching trigger template found")}}}K=null}function h(G,H){this.type=G.type;this.name=G.name;this.fireTriggerIds=G.fireTriggerIds?G.fireTriggerIds:[];this.blockTriggerIds=G.blockTriggerIds?G.blockTriggerIds:[];this.fireLimit=G.fireLimit?G.fireLimit:h.FIRE_LIMIT_UNLIMITED;this.fireDelay=G.fireDelay?parseInt(G.fireDelay,10):0;this.startDate=G.startDate?G.startDate:null;this.endDate=G.endDate?G.endDate:null;this.numExecuted=0;this.blocked=false;this.parameters=G.parameters||{};var I=this;this.addDebugValues=function(i,L){i.push({action:L,type:this.type,name:this.name,numExecuted:this.numExecuted})};this._doFire=function(){if(this.blocked){y.log("not firing as this tag is blocked",this);
return"tag is blocked"}if(this.fireLimit!==h.FIRE_LIMIT_UNLIMITED&&this.numExecuted){y.log("not firing as this tag has limit reached",this);return"fire limit is restricted"}var L="tag";if(H.id){L+="_"+H.id}if(this.fireLimit===h.FIRE_LIMIT_ONCE_24HOURS&&!window.mtmPreviewWindow){if(x.get(L,this.name)){y.log("not firing as this tag has 24hours limit reached",this);return"fire limit 24hours is restricted"}}if(this.fireLimit===h.FIRE_LIMIT_ONCE_LIFETIME&&!window.mtmPreviewWindow){if(x.get(L,this.name)){y.log("not firing as this tag has limit reached",this);return"fire limit lifetime is restricted"}}if(!E.matchesDateRange(new Date(),this.startDate,this.endDate)){y.log("not firing as this tag does not match date",this);return"date range does not match"}if(!this.theTag||!this.theTag.fire){y.log("not firing as tag does not exist anymore",this);return"tag not found"}y.log("firing this tag",this);this.numExecuted++;if(this.fireLimit===h.FIRE_LIMIT_ONCE_24HOURS){var i=24*60*60;x.set(L,this.name,"1",i)
}if(this.fireLimit===h.FIRE_LIMIT_ONCE_LIFETIME){x.set(L,this.name,"1")}this.theTag.fire();y.log("fired this tag",this)};this.fire=function(){if(this.fireDelay){setTimeout(function(){I._doFire()},this.fireDelay)}else{return this._doFire()}};this.block=function(){this.blocked=true};this.hasFireTrigger=function(i){if(!this.fireTriggerIds||!this.fireTriggerIds.length){return false}if(!i){return false}var L=i.getId();return B.indexOfArray(this.fireTriggerIds,L)!==-1};this.hasBlockTrigger=function(i){if(!this.blockTriggerIds||!this.blockTriggerIds.length){return false}if(!i){return false}var L=i.getId();return B.indexOfArray(this.blockTriggerIds,L)!==-1};if(!B.isDefined(G.Tag)||!G.Tag){y.error("no template defined for tag ",G);return}var J,K=new w({tag:this,container:H});if(B.isObject(G.parameters)){for(J in G.parameters){if(B.hasProperty(G.parameters,J)){K.set(J,o(G.parameters[J],H))}}}if(B.isFunction(G.Tag)){this.theTag=new G.Tag(K,l)}else{if(B.isObject(G.Tag)){this.theTag=G.Tag}else{if(G.Tag in H.templates){this.theTag=new H.templates[G.Tag](K,l)
}else{C("No matching tag template found")}}}}h.FIRE_LIMIT_ONCE_PAGE="once_page";h.FIRE_LIMIT_ONCE_24HOURS="once_24hours";h.FIRE_LIMIT_ONCE_LIFETIME="once_lifetime";h.FIRE_LIMIT_UNLIMITED="unlimited";function n(H,M){var I=this;this.id=H.id;this.idsite=H.idsite||null;this.versionName=H.versionName||null;this.revision=H.revision||null;this.environment=H.environment||null;this.templates=M||{};this.dataLayer=new t();this.variables=[];this.triggers=[];this.tags=[];this.onNewGlobalDataLayerValue=function(i){this.dataLayer.push(i)};p.on(function(i){I.onNewGlobalDataLayerValue(i)});this.addDebugValues=function(O){O.variables=[];var P;for(P=0;P<this.variables.length;P++){this.variables[P].addDebugValues(O.variables)}O.tags=[];for(P=0;P<this.tags.length;P++){this.tags[P].addDebugValues(O.tags,"Not Fired Yet")}O.id=this.id;O.versionName=this.versionName;O.dataLayer=JSON.parse(JSON.stringify(this.dataLayer.values,function(i,Q){if(typeof Q==="object"&&Q instanceof Node){return Q.nodeName}else{return Q
}}))};this.getTriggerById=function(O){if(!O){return}var P;for(P=0;P<this.triggers.length;P++){if(this.triggers[P].getId()===O){return this.triggers[P]}}};this.addTrigger=function(i){if(!i){return}var O=this.getTriggerById(i.id);if(!O){O=new f(i,this);this.triggers.push(O)}return O};var L,K,G,N,J;if(H.variables&&B.isArray(H.variables)){for(L=0;L<H.variables.length;L++){this.variables.push(o(H.variables[L],this))}}if(H.triggers&&B.isArray(H.triggers)){if(H.tags&&B.isArray(H.tags)){H.triggers.sort(function(P,O){var Q=false,S=false,i,R;for(R=0;R<H.tags.length;R++){i=H.tags[R];if(i&&i.blockTriggerIds&&B.isArray(i.blockTriggerIds)){Q=Q||B.indexOfArray(i.blockTriggerIds,P.id)!==-1;S=S||B.indexOfArray(i.blockTriggerIds,O.id)!==-1}}if(Q&&!S){return -1}else{if(S&&!Q){return 1}}if(P.id<O.id){return -1}return 1})}for(L=0;L<H.triggers.length;L++){this.addTrigger(H.triggers[L])}}if(H.tags&&B.isArray(H.tags)){for(L=0;L<H.tags.length;L++){N=H.tags[L];G=new h(N,this);this.tags.push(G);if(N.blockTriggerIds&&B.isArray(N.blockTriggerIds)){for(K=0;
K<N.blockTriggerIds.length;K++){J=this.getTriggerById(N.blockTriggerIds[K]);if(J){J.addReferencedTag(G)}}}if(N.fireTriggerIds&&B.isArray(N.fireTriggerIds)){for(K=0;K<N.fireTriggerIds.length;K++){J=this.getTriggerById(N.fireTriggerIds[K]);if(J){J.addReferencedTag(G)}}}}}this.run=function(){var P=p.getAllEvents();var O;for(O=0;O<P.length;O++){this.onNewGlobalDataLayerValue(P[O])}for(O=0;O<this.triggers.length;O++){this.triggers[O].setUp()}}}var l={THROW_ERRORS:true,dataLayer:p,containers:[],url:r,date:E,utils:B,debug:y,dom:A,window:D,Variable:s,storage:{local:x,session:e},_buildVariable:o,Condition:z,TemplateParameters:w,Trigger:f,Tag:h,throwError:C,Container:n,addContainer:function(M,J){var K=r.getQueryParameter("mtmSetDebugFlag");if(K){var H=encodeURIComponent(M.idsite);var i=encodeURIComponent(M.id);if(K==1){var I=new Date();I.setTime(I.getTime()+(7*24*60*60*1000));document.cookie="mtmPreviewMode=mtmPreview"+H+"_"+i+"%3D1;expires="+I.toUTCString()+";SameSite=Lax"}else{document.cookie="mtmPreviewMode=mtmPreview"+H+"_"+i+"%3D1;expires=Thu, 01 Jan 1970 00:00:00 UTC;SameSite=Lax";
window.close()}}if(!window.mtmPreviewWindow){var L=b.getElementById("mtmDebugFrame");if(L&&L.contentWindow){window.mtmPreviewWindow=L.contentWindow}}y.log("creating container");var G=new n(M,J);this.containers.push(G);G.dataLayer.push({"mtm.containerId":G.id});y.log("running container");G.run();return G},enableDebugMode:function(){y.enabled=true}};if("matomoTagManagerAsyncInit" in a&&B.isFunction(a.matomoTagManagerAsyncInit)){a.matomoTagManagerAsyncInit(l)}function g(){var K,I,H,M,N;for(K=0;K<arguments.length;K+=1){N=null;if(arguments[K]&&arguments[K].slice){N=arguments[K].slice()}M=arguments[K];if(B.isObject(M)&&!B.isArray(M)){p.push(M);continue}H=M.shift();var L=B.isString(H)&&H.indexOf("::")>0;if(L){var G,J;G=H.split("::");J=G[0];H=G[1];if("object"===typeof l[J]&&B.isFunction(l[J][H])){l[J][H].apply(l[J],M)}}else{if(H&&H in l&&B.isFunction(l[H])){l[H].apply(l,M)}else{y.error("method "+H+" is not valid")}}}}B.setMethodWrapIfNeeded(a._mtm,"push",g);var v;for(v=0;v<a._mtm.length;v++){g(a._mtm[v])
}p.push({"mtm.mtmScriptLoadedTime":k});if("undefined"!==typeof a.dataLayer&&B.isArray(a.dataLayer)){for(v=0;v<a.dataLayer.length;v++){if(B.isObject(a.dataLayer[v])){p.push(a.dataLayer[v])}}}return l})()}
(function(){
var Templates = {};
Templates['MatomoTag'] = (function(){var libLoaded=false;var libAvailable=false;var callbacks={callbacks:[],push:function(callback){if(libAvailable){callback();}else{this.callbacks.push(callback);}}};window._paq=window._paq||[];if('object'!==typeof window.matomoPluginAsyncInit){window.matomoPluginAsyncInit=[];}
function executeCallbacks(){var i;for(i=0;i<callbacks.callbacks.length;i++){callbacks.callbacks[i]();}
callbacks.callbacks=[];}
window.matomoPluginAsyncInit.push(function(){libAvailable=true;executeCallbacks();});function checkLoadedAlready(){if(libAvailable||typeof window.Piwik==='object'){libAvailable=true;libLoaded=true;executeCallbacks();return true;}
return false;}
function loadMatomo(){if(checkLoadedAlready()){return;}
/*!!
 * Matomo - free/libre analytics platform
 *
 * JavaScript tracking client
 *
 * @link https://piwik.org
 * @source https://github.com/matomo-org/matomo/blob/master/js/piwik.js
 * @license https://piwik.org/free-software/bsd/ BSD-3 Clause (also in js/LICENSE.txt)
 * @license magnet:?xt=urn:btih:c80d50af7d3db9be66a4d0a86db0286e4fd33292&dn=bsd-3-clause.txt BSD-3-Clause
 */
;if(typeof _paq!=="object"){_paq=[]}if(typeof window.Matomo!=="object"){window.Matomo=window.Piwik=(function(){var r,b={},z={},J=document,g=navigator,ab=screen,W=window,h=W.performance||W.mozPerformance||W.msPerformance||W.webkitPerformance,t=W.encodeURIComponent,V=W.decodeURIComponent,k=unescape,L=[],H,u,al=[],y=0,af=0,X=0,m=false;function p(at){try{return V(at)}catch(au){return unescape(at)}}function M(au){var at=typeof au;return at!=="undefined"}function C(at){return typeof at==="function"}function Z(at){return typeof at==="object"}function x(at){return typeof at==="string"||at instanceof String}function ak(at){return typeof at==="number"||at instanceof Number
}function ac(at){return M(at)&&(ak(at)||(x(at)&&at.length))}function D(au){if(!au){return true}var at;for(at in au){if(Object.prototype.hasOwnProperty.call(au,at)){return false}}return true}function ao(at){var au=typeof console;if(au!=="undefined"&&console&&console.error){console.error(at)}}function aj(){var ay,ax,aA,au,at;for(ay=0;ay<arguments.length;ay+=1){at=null;if(arguments[ay]&&arguments[ay].slice){at=arguments[ay].slice()}au=arguments[ay];aA=au.shift();var az,av;var aw=x(aA)&&aA.indexOf("::")>0;if(aw){az=aA.split("::");av=az[0];aA=az[1];if("object"===typeof u[av]&&"function"===typeof u[av][aA]){u[av][aA].apply(u[av],au)}else{if(at){al.push(at)}}}else{for(ax=0;ax<L.length;ax++){if(x(aA)){av=L[ax];var aB=aA.indexOf(".")>0;if(aB){az=aA.split(".");if(av&&"object"===typeof av[az[0]]){av=av[az[0]];aA=az[1]}else{if(at){al.push(at);break}}}if(av[aA]){av[aA].apply(av,au)}else{var aC="The method '"+aA+'\' was not found in "_paq" variable.  Please have a look at the Matomo tracker documentation: https://developer.matomo.org/api-reference/tracking-javascript';
ao(aC);if(!aB){throw new TypeError(aC)}}if(aA==="addTracker"){break}if(aA==="setTrackerUrl"||aA==="setSiteId"){break}}else{aA.apply(L[ax],au)}}}}}function ar(aw,av,au,at){if(aw.addEventListener){aw.addEventListener(av,au,at);return true}if(aw.attachEvent){return aw.attachEvent("on"+av,au)}aw["on"+av]=au}function n(at){if(J.readyState==="complete"){at()}else{if(W.addEventListener){W.addEventListener("load",at,false)}else{if(W.attachEvent){W.attachEvent("onload",at)}}}}function q(aw){var at=false;if(J.attachEvent){at=J.readyState==="complete"}else{at=J.readyState!=="loading"}if(at){aw();return}var av;if(J.addEventListener){ar(J,"DOMContentLoaded",function au(){J.removeEventListener("DOMContentLoaded",au,false);if(!at){at=true;aw()}})}else{if(J.attachEvent){J.attachEvent("onreadystatechange",function au(){if(J.readyState==="complete"){J.detachEvent("onreadystatechange",au);if(!at){at=true;aw()}}});if(J.documentElement.doScroll&&W===W.top){(function au(){if(!at){try{J.documentElement.doScroll("left")
}catch(ax){setTimeout(au,0);return}at=true;aw()}}())}}}ar(W,"load",function(){if(!at){at=true;aw()}},false)}function ag(au,az,aA){if(!au){return""}var at="",aw,av,ax,ay;for(aw in b){if(Object.prototype.hasOwnProperty.call(b,aw)){ay=b[aw]&&"function"===typeof b[aw][au];if(ay){av=b[aw][au];ax=av(az||{},aA);if(ax){at+=ax}}}}return at}function am(au){var at;m=true;ag("unload");at=new Date();var av=at.getTimeAlias();if((r-av)>3000){r=av+3000}if(r){do{at=new Date()}while(at.getTimeAlias()<r)}}function o(av,au){var at=J.createElement("script");at.type="text/javascript";at.src=av;if(at.readyState){at.onreadystatechange=function(){var aw=this.readyState;if(aw==="loaded"||aw==="complete"){at.onreadystatechange=null;au()}}}else{at.onload=au}J.getElementsByTagName("head")[0].appendChild(at)}function N(){var at="";try{at=W.top.document.referrer}catch(av){if(W.parent){try{at=W.parent.document.referrer}catch(au){at=""}}}if(at===""){at=J.referrer}return at}function s(at){var av=new RegExp("^([a-z]+):"),au=av.exec(at);
return au?au[1]:null}function d(at){var av=new RegExp("^(?:(?:https?|ftp):)/*(?:[^@]+@)?([^:/#]+)"),au=av.exec(at);return au?au[1]:at}function G(at){return(/^[0-9][0-9]*(\.[0-9]+)?$/).test(at)}function Q(av,aw){var at={},au;for(au in av){if(av.hasOwnProperty(au)&&aw(av[au])){at[au]=av[au]}}return at}function B(av){var at={},au;for(au in av){if(av.hasOwnProperty(au)){if(G(av[au])){at[au]=Math.round(av[au])}else{throw new Error('Parameter "'+au+'" provided value "'+av[au]+'" is not valid. Please provide a numeric value.')}}}return at}function l(au){var av="",at;for(at in au){if(au.hasOwnProperty(at)){av+="&"+t(at)+"="+t(au[at])}}return av}function an(au,at){au=String(au);return au.lastIndexOf(at,0)===0}function U(au,at){au=String(au);return au.indexOf(at,au.length-at.length)!==-1}function A(au,at){au=String(au);return au.indexOf(at)!==-1}function f(au,at){au=String(au);return au.substr(0,au.length-at)}function I(aw,av,ay){aw=String(aw);if(!ay){ay=""}var at=aw.indexOf("#");var az=aw.length;
if(at===-1){at=az}var ax=aw.substr(0,at);var au=aw.substr(at,az-at);if(ax.indexOf("?")===-1){ax+="?"}else{if(!U(ax,"?")){ax+="&"}}return ax+t(av)+"="+t(ay)+au}function j(au,av){au=String(au);if(au.indexOf("?"+av+"=")===-1&&au.indexOf("&"+av+"=")===-1){return au}var aw=au.indexOf("?");if(aw===-1){return au}var at=au.substr(aw+1);var aA=au.substr(0,aw);if(at){var aB="";var aD=at.indexOf("#");if(aD!==-1){aB=at.substr(aD+1);at=at.substr(0,aD)}var ax;var az=at.split("&");var ay=az.length-1;for(ay;ay>=0;ay--){ax=az[ay].split("=")[0];if(ax===av){az.splice(ay,1)}}var aC=az.join("&");if(aC){aA=aA+"?"+aC}if(aB){aA+="#"+aB}}return aA}function e(av,au){var at="[\\?&#]"+au+"=([^&#]*)";var ax=new RegExp(at);var aw=ax.exec(av);return aw?p(aw[1]):""}function a(at){if(at&&String(at)===at){return at.replace(/^\s+|\s+$/g,"")}return at}function F(at){return unescape(t(at))}function aq(aI){var av=function(aO,aN){return(aO<<aN)|(aO>>>(32-aN))},aJ=function(aQ){var aO="",aP,aN;for(aP=7;aP>=0;aP--){aN=(aQ>>>(aP*4))&15;
aO+=aN.toString(16)}return aO},ay,aL,aK,au=[],aC=1732584193,aA=4023233417,az=2562383102,ax=271733878,aw=3285377520,aH,aG,aF,aE,aD,aM,at,aB=[];aI=F(aI);at=aI.length;for(aL=0;aL<at-3;aL+=4){aK=aI.charCodeAt(aL)<<24|aI.charCodeAt(aL+1)<<16|aI.charCodeAt(aL+2)<<8|aI.charCodeAt(aL+3);aB.push(aK)}switch(at&3){case 0:aL=2147483648;break;case 1:aL=aI.charCodeAt(at-1)<<24|8388608;break;case 2:aL=aI.charCodeAt(at-2)<<24|aI.charCodeAt(at-1)<<16|32768;break;case 3:aL=aI.charCodeAt(at-3)<<24|aI.charCodeAt(at-2)<<16|aI.charCodeAt(at-1)<<8|128;break}aB.push(aL);while((aB.length&15)!==14){aB.push(0)}aB.push(at>>>29);aB.push((at<<3)&4294967295);for(ay=0;ay<aB.length;ay+=16){for(aL=0;aL<16;aL++){au[aL]=aB[ay+aL]}for(aL=16;aL<=79;aL++){au[aL]=av(au[aL-3]^au[aL-8]^au[aL-14]^au[aL-16],1)}aH=aC;aG=aA;aF=az;aE=ax;aD=aw;for(aL=0;aL<=19;aL++){aM=(av(aH,5)+((aG&aF)|(~aG&aE))+aD+au[aL]+1518500249)&4294967295;aD=aE;aE=aF;aF=av(aG,30);aG=aH;aH=aM}for(aL=20;aL<=39;aL++){aM=(av(aH,5)+(aG^aF^aE)+aD+au[aL]+1859775393)&4294967295;
aD=aE;aE=aF;aF=av(aG,30);aG=aH;aH=aM}for(aL=40;aL<=59;aL++){aM=(av(aH,5)+((aG&aF)|(aG&aE)|(aF&aE))+aD+au[aL]+2400959708)&4294967295;aD=aE;aE=aF;aF=av(aG,30);aG=aH;aH=aM}for(aL=60;aL<=79;aL++){aM=(av(aH,5)+(aG^aF^aE)+aD+au[aL]+3395469782)&4294967295;aD=aE;aE=aF;aF=av(aG,30);aG=aH;aH=aM}aC=(aC+aH)&4294967295;aA=(aA+aG)&4294967295;az=(az+aF)&4294967295;ax=(ax+aE)&4294967295;aw=(aw+aD)&4294967295}aM=aJ(aC)+aJ(aA)+aJ(az)+aJ(ax)+aJ(aw);return aM.toLowerCase()}function ae(av,at,au){if(!av){av=""}if(!at){at=""}if(av==="translate.googleusercontent.com"){if(au===""){au=at}at=e(at,"u");av=d(at)}else{if(av==="cc.bingj.com"||av==="webcache.googleusercontent.com"||av.slice(0,5)==="74.6."){at=J.links[0].href;av=d(at)}}return[av,at,au]}function O(au){var at=au.length;if(au.charAt(--at)==="."){au=au.slice(0,at)}if(au.slice(0,2)==="*."){au=au.slice(1)}if(au.indexOf("/")!==-1){au=au.substr(0,au.indexOf("/"))}return au}function ap(au){au=au&&au.text?au.text:au;if(!x(au)){var at=J.getElementsByTagName("title");
if(at&&M(at[0])){au=at[0].text}}return au}function S(at){if(!at){return[]}if(!M(at.children)&&M(at.childNodes)){return at.children}if(M(at.children)){return at.children}return[]}function Y(au,at){if(!au||!at){return false}if(au.contains){return au.contains(at)}if(au===at){return true}if(au.compareDocumentPosition){return !!(au.compareDocumentPosition(at)&16)}return false}function P(av,aw){if(av&&av.indexOf){return av.indexOf(aw)}if(!M(av)||av===null){return -1}if(!av.length){return -1}var at=av.length;if(at===0){return -1}var au=0;while(au<at){if(av[au]===aw){return au}au++}return -1}function i(av){if(!av){return false}function at(ax,ay){if(W.getComputedStyle){return J.defaultView.getComputedStyle(ax,null)[ay]}if(ax.currentStyle){return ax.currentStyle[ay]}}function aw(ax){ax=ax.parentNode;while(ax){if(ax===J){return true}ax=ax.parentNode}return false}function au(az,aF,ax,aC,aA,aD,aB){var ay=az.parentNode,aE=1;if(!aw(az)){return false}if(9===ay.nodeType){return true}if("0"===at(az,"opacity")||"none"===at(az,"display")||"hidden"===at(az,"visibility")){return false
}if(!M(aF)||!M(ax)||!M(aC)||!M(aA)||!M(aD)||!M(aB)){aF=az.offsetTop;aA=az.offsetLeft;aC=aF+az.offsetHeight;ax=aA+az.offsetWidth;aD=az.offsetWidth;aB=az.offsetHeight}if(av===az&&(0===aB||0===aD)&&"hidden"===at(az,"overflow")){return false}if(ay){if(("hidden"===at(ay,"overflow")||"scroll"===at(ay,"overflow"))){if(aA+aE>ay.offsetWidth+ay.scrollLeft||aA+aD-aE<ay.scrollLeft||aF+aE>ay.offsetHeight+ay.scrollTop||aF+aB-aE<ay.scrollTop){return false}}if(az.offsetParent===ay){aA+=ay.offsetLeft;aF+=ay.offsetTop}return au(ay,aF,ax,aC,aA,aD,aB)}return true}return au(av)}var ai={htmlCollectionToArray:function(av){var at=[],au;if(!av||!av.length){return at}for(au=0;au<av.length;au++){at.push(av[au])}return at},find:function(at){if(!document.querySelectorAll||!at){return[]}var au=document.querySelectorAll(at);return this.htmlCollectionToArray(au)},findMultiple:function(av){if(!av||!av.length){return[]}var au,aw;var at=[];for(au=0;au<av.length;au++){aw=this.find(av[au]);at=at.concat(aw)}at=this.makeNodesUnique(at);
return at},findNodesByTagName:function(au,at){if(!au||!at||!au.getElementsByTagName){return[]}var av=au.getElementsByTagName(at);return this.htmlCollectionToArray(av)},makeNodesUnique:function(at){var ay=[].concat(at);at.sort(function(aA,az){if(aA===az){return 0}var aC=P(ay,aA);var aB=P(ay,az);if(aC===aB){return 0}return aC>aB?-1:1});if(at.length<=1){return at}var au=0;var aw=0;var ax=[];var av;av=at[au++];while(av){if(av===at[au]){aw=ax.push(au)}av=at[au++]||null}while(aw--){at.splice(ax[aw],1)}return at},getAttributeValueFromNode:function(ax,av){if(!this.hasNodeAttribute(ax,av)){return}if(ax&&ax.getAttribute){return ax.getAttribute(av)}if(!ax||!ax.attributes){return}var aw=(typeof ax.attributes[av]);if("undefined"===aw){return}if(ax.attributes[av].value){return ax.attributes[av].value}if(ax.attributes[av].nodeValue){return ax.attributes[av].nodeValue}var au;var at=ax.attributes;if(!at){return}for(au=0;au<at.length;au++){if(at[au].nodeName===av){return at[au].nodeValue}}return null},hasNodeAttributeWithValue:function(au,at){var av=this.getAttributeValueFromNode(au,at);
return !!av},hasNodeAttribute:function(av,at){if(av&&av.hasAttribute){return av.hasAttribute(at)}if(av&&av.attributes){var au=(typeof av.attributes[at]);return"undefined"!==au}return false},hasNodeCssClass:function(av,at){if(av&&at&&av.className){var au=typeof av.className==="string"?av.className.split(" "):[];if(-1!==P(au,at)){return true}}return false},findNodesHavingAttribute:function(ax,av,at){if(!at){at=[]}if(!ax||!av){return at}var aw=S(ax);if(!aw||!aw.length){return at}var au,ay;for(au=0;au<aw.length;au++){ay=aw[au];if(this.hasNodeAttribute(ay,av)){at.push(ay)}at=this.findNodesHavingAttribute(ay,av,at)}return at},findFirstNodeHavingAttribute:function(av,au){if(!av||!au){return}if(this.hasNodeAttribute(av,au)){return av}var at=this.findNodesHavingAttribute(av,au);if(at&&at.length){return at[0]}},findFirstNodeHavingAttributeWithValue:function(aw,av){if(!aw||!av){return}if(this.hasNodeAttributeWithValue(aw,av)){return aw}var at=this.findNodesHavingAttribute(aw,av);if(!at||!at.length){return
}var au;for(au=0;au<at.length;au++){if(this.getAttributeValueFromNode(at[au],av)){return at[au]}}},findNodesHavingCssClass:function(ax,aw,at){if(!at){at=[]}if(!ax||!aw){return at}if(ax.getElementsByClassName){var ay=ax.getElementsByClassName(aw);return this.htmlCollectionToArray(ay)}var av=S(ax);if(!av||!av.length){return[]}var au,az;for(au=0;au<av.length;au++){az=av[au];if(this.hasNodeCssClass(az,aw)){at.push(az)}at=this.findNodesHavingCssClass(az,aw,at)}return at},findFirstNodeHavingClass:function(av,au){if(!av||!au){return}if(this.hasNodeCssClass(av,au)){return av}var at=this.findNodesHavingCssClass(av,au);if(at&&at.length){return at[0]}},isLinkElement:function(au){if(!au){return false}var at=String(au.nodeName).toLowerCase();var aw=["a","area"];var av=P(aw,at);return av!==-1},setAnyAttribute:function(au,at,av){if(!au||!at){return}if(au.setAttribute){au.setAttribute(at,av)}else{au[at]=av}}};var w={CONTENT_ATTR:"data-track-content",CONTENT_CLASS:"matomoTrackContent",LEGACY_CONTENT_CLASS:"piwikTrackContent",CONTENT_NAME_ATTR:"data-content-name",CONTENT_PIECE_ATTR:"data-content-piece",CONTENT_PIECE_CLASS:"matomoContentPiece",LEGACY_CONTENT_PIECE_CLASS:"piwikContentPiece",CONTENT_TARGET_ATTR:"data-content-target",CONTENT_TARGET_CLASS:"matomoContentTarget",LEGACY_CONTENT_TARGET_CLASS:"piwikContentTarget",CONTENT_IGNOREINTERACTION_ATTR:"data-content-ignoreinteraction",CONTENT_IGNOREINTERACTION_CLASS:"matomoContentIgnoreInteraction",LEGACY_CONTENT_IGNOREINTERACTION_CLASS:"piwikContentIgnoreInteraction",location:undefined,findContentNodes:function(){var au="."+this.CONTENT_CLASS;
var av="."+this.LEGACY_CONTENT_CLASS;var at="["+this.CONTENT_ATTR+"]";var aw=ai.findMultiple([au,av,at]);return aw},findContentNodesWithinNode:function(aw){if(!aw){return[]}var au=ai.findNodesHavingCssClass(aw,this.CONTENT_CLASS);au=ai.findNodesHavingCssClass(aw,this.LEGACY_CONTENT_CLASS,au);var at=ai.findNodesHavingAttribute(aw,this.CONTENT_ATTR);if(at&&at.length){var av;for(av=0;av<at.length;av++){au.push(at[av])}}if(ai.hasNodeAttribute(aw,this.CONTENT_ATTR)){au.push(aw)}else{if(ai.hasNodeCssClass(aw,this.CONTENT_CLASS)){au.push(aw)}else{if(ai.hasNodeCssClass(aw,this.LEGACY_CONTENT_CLASS)){au.push(aw)}}}au=ai.makeNodesUnique(au);return au},findParentContentNode:function(au){if(!au){return}var av=au;var at=0;while(av&&av!==J&&av.parentNode){if(ai.hasNodeAttribute(av,this.CONTENT_ATTR)){return av}if(ai.hasNodeCssClass(av,this.CONTENT_CLASS)){return av}if(ai.hasNodeCssClass(av,this.LEGACY_CONTENT_CLASS)){return av}av=av.parentNode;if(at>1000){break}at++}},findPieceNode:function(au){var at;
at=ai.findFirstNodeHavingAttribute(au,this.CONTENT_PIECE_ATTR);if(!at){at=ai.findFirstNodeHavingClass(au,this.CONTENT_PIECE_CLASS)}if(!at){at=ai.findFirstNodeHavingClass(au,this.LEGACY_CONTENT_PIECE_CLASS)}if(at){return at}return au},findTargetNodeNoDefault:function(at){if(!at){return}var au=ai.findFirstNodeHavingAttributeWithValue(at,this.CONTENT_TARGET_ATTR);if(au){return au}au=ai.findFirstNodeHavingAttribute(at,this.CONTENT_TARGET_ATTR);if(au){return au}au=ai.findFirstNodeHavingClass(at,this.CONTENT_TARGET_CLASS);if(au){return au}au=ai.findFirstNodeHavingClass(at,this.LEGACY_CONTENT_TARGET_CLASS);if(au){return au}},findTargetNode:function(at){var au=this.findTargetNodeNoDefault(at);if(au){return au}return at},findContentName:function(au){if(!au){return}var ax=ai.findFirstNodeHavingAttributeWithValue(au,this.CONTENT_NAME_ATTR);if(ax){return ai.getAttributeValueFromNode(ax,this.CONTENT_NAME_ATTR)}var at=this.findContentPiece(au);if(at){return this.removeDomainIfIsInLink(at)}if(ai.hasNodeAttributeWithValue(au,"title")){return ai.getAttributeValueFromNode(au,"title")
}var av=this.findPieceNode(au);if(ai.hasNodeAttributeWithValue(av,"title")){return ai.getAttributeValueFromNode(av,"title")}var aw=this.findTargetNode(au);if(ai.hasNodeAttributeWithValue(aw,"title")){return ai.getAttributeValueFromNode(aw,"title")}},findContentPiece:function(au){if(!au){return}var aw=ai.findFirstNodeHavingAttributeWithValue(au,this.CONTENT_PIECE_ATTR);if(aw){return ai.getAttributeValueFromNode(aw,this.CONTENT_PIECE_ATTR)}var at=this.findPieceNode(au);var av=this.findMediaUrlInNode(at);if(av){return this.toAbsoluteUrl(av)}},findContentTarget:function(av){if(!av){return}var aw=this.findTargetNode(av);if(ai.hasNodeAttributeWithValue(aw,this.CONTENT_TARGET_ATTR)){return ai.getAttributeValueFromNode(aw,this.CONTENT_TARGET_ATTR)}var au;if(ai.hasNodeAttributeWithValue(aw,"href")){au=ai.getAttributeValueFromNode(aw,"href");return this.toAbsoluteUrl(au)}var at=this.findPieceNode(av);if(ai.hasNodeAttributeWithValue(at,"href")){au=ai.getAttributeValueFromNode(at,"href");return this.toAbsoluteUrl(au)
}},isSameDomain:function(at){if(!at||!at.indexOf){return false}if(0===at.indexOf(this.getLocation().origin)){return true}var au=at.indexOf(this.getLocation().host);if(8>=au&&0<=au){return true}return false},removeDomainIfIsInLink:function(av){var au="^https?://[^/]+";var at="^.*//[^/]+";if(av&&av.search&&-1!==av.search(new RegExp(au))&&this.isSameDomain(av)){av=av.replace(new RegExp(at),"");if(!av){av="/"}}return av},findMediaUrlInNode:function(ax){if(!ax){return}var av=["img","embed","video","audio"];var at=ax.nodeName.toLowerCase();if(-1!==P(av,at)&&ai.findFirstNodeHavingAttributeWithValue(ax,"src")){var aw=ai.findFirstNodeHavingAttributeWithValue(ax,"src");return ai.getAttributeValueFromNode(aw,"src")}if(at==="object"&&ai.hasNodeAttributeWithValue(ax,"data")){return ai.getAttributeValueFromNode(ax,"data")}if(at==="object"){var ay=ai.findNodesByTagName(ax,"param");if(ay&&ay.length){var au;for(au=0;au<ay.length;au++){if("movie"===ai.getAttributeValueFromNode(ay[au],"name")&&ai.hasNodeAttributeWithValue(ay[au],"value")){return ai.getAttributeValueFromNode(ay[au],"value")
}}}var az=ai.findNodesByTagName(ax,"embed");if(az&&az.length){return this.findMediaUrlInNode(az[0])}}},trim:function(at){return a(at)},isOrWasNodeInViewport:function(ay){if(!ay||!ay.getBoundingClientRect||ay.nodeType!==1){return true}var ax=ay.getBoundingClientRect();var aw=J.documentElement||{};var av=ax.top<0;if(av&&ay.offsetTop){av=(ay.offsetTop+ax.height)>0}var au=aw.clientWidth;if(W.innerWidth&&au>W.innerWidth){au=W.innerWidth}var at=aw.clientHeight;if(W.innerHeight&&at>W.innerHeight){at=W.innerHeight}return((ax.bottom>0||av)&&ax.right>0&&ax.left<au&&((ax.top<at)||av))},isNodeVisible:function(au){var at=i(au);var av=this.isOrWasNodeInViewport(au);return at&&av},buildInteractionRequestParams:function(at,au,av,aw){var ax="";if(at){ax+="c_i="+t(at)}if(au){if(ax){ax+="&"}ax+="c_n="+t(au)}if(av){if(ax){ax+="&"}ax+="c_p="+t(av)}if(aw){if(ax){ax+="&"}ax+="c_t="+t(aw)}if(ax){ax+="&ca=1"}return ax},buildImpressionRequestParams:function(at,au,av){var aw="c_n="+t(at)+"&c_p="+t(au);if(av){aw+="&c_t="+t(av)
}if(aw){aw+="&ca=1"}return aw},buildContentBlock:function(av){if(!av){return}var at=this.findContentName(av);var au=this.findContentPiece(av);var aw=this.findContentTarget(av);at=this.trim(at);au=this.trim(au);aw=this.trim(aw);return{name:at||"Unknown",piece:au||"Unknown",target:aw||""}},collectContent:function(aw){if(!aw||!aw.length){return[]}var av=[];var at,au;for(at=0;at<aw.length;at++){au=this.buildContentBlock(aw[at]);if(M(au)){av.push(au)}}return av},setLocation:function(at){this.location=at},getLocation:function(){var at=this.location||W.location;if(!at.origin){at.origin=at.protocol+"//"+at.hostname+(at.port?":"+at.port:"")}return at},toAbsoluteUrl:function(au){if((!au||String(au)!==au)&&au!==""){return au}if(""===au){return this.getLocation().href}if(au.search(/^\/\//)!==-1){return this.getLocation().protocol+au}if(au.search(/:\/\//)!==-1){return au}if(0===au.indexOf("#")){return this.getLocation().origin+this.getLocation().pathname+au}if(0===au.indexOf("?")){return this.getLocation().origin+this.getLocation().pathname+au
}if(0===au.search("^[a-zA-Z]{2,11}:")){return au}if(au.search(/^\//)!==-1){return this.getLocation().origin+au}var at="(.*/)";var av=this.getLocation().origin+this.getLocation().pathname.match(new RegExp(at))[0];return av+au},isUrlToCurrentDomain:function(au){var av=this.toAbsoluteUrl(au);if(!av){return false}var at=this.getLocation().origin;if(at===av){return true}if(0===String(av).indexOf(at)){if(":"===String(av).substr(at.length,1)){return false}return true}return false},setHrefAttribute:function(au,at){if(!au||!at){return}ai.setAnyAttribute(au,"href",at)},shouldIgnoreInteraction:function(at){if(ai.hasNodeAttribute(at,this.CONTENT_IGNOREINTERACTION_ATTR)){return true}if(ai.hasNodeCssClass(at,this.CONTENT_IGNOREINTERACTION_CLASS)){return true}if(ai.hasNodeCssClass(at,this.LEGACY_CONTENT_IGNOREINTERACTION_CLASS)){return true}return false}};function aa(au,ax){if(ax){return ax}au=w.toAbsoluteUrl(au);if(A(au,"?")){var aw=au.indexOf("?");au=au.slice(0,aw)}if(U(au,"matomo.php")){au=f(au,"matomo.php".length)
}else{if(U(au,"piwik.php")){au=f(au,"piwik.php".length)}else{if(U(au,".php")){var at=au.lastIndexOf("/");var av=1;au=au.slice(0,at+av)}}}if(U(au,"/js/")){au=f(au,"js/".length)}return au}function R(az){var aB="Matomo_Overlay";var au=new RegExp("index\\.php\\?module=Overlay&action=startOverlaySession&idSite=([0-9]+)&period=([^&]+)&date=([^&]+)(&segment=[^&]*)?");var av=au.exec(J.referrer);if(av){var ax=av[1];if(ax!==String(az)){return false}var ay=av[2],at=av[3],aw=av[4];if(!aw){aw=""}else{if(aw.indexOf("&segment=")===0){aw=aw.substr("&segment=".length)}}W.name=aB+"###"+ay+"###"+at+"###"+aw}var aA=W.name.split("###");return aA.length===4&&aA[0]===aB}function ad(au,az,av){var ay=W.name.split("###"),ax=ay[1],at=ay[2],aw=ay[3],aA=aa(au,az);o(aA+"plugins/Overlay/client/client.js?v=1",function(){Matomo_Overlay_Client.initialize(aA,av,ax,at,aw)})}function v(){var av;try{av=W.frameElement}catch(au){return true}if(M(av)){return(av&&String(av.nodeName).toLowerCase()==="iframe")?true:false}try{return W.self!==W.top
}catch(at){return true}}function T(cj,cf){var bP=this,bj="mtm_consent",cL="mtm_cookie_consent",cU="mtm_consent_removed",ca=ae(J.domain,W.location.href,N()),c2=O(ca[0]),bT=p(ca[1]),bu=p(ca[2]),c0=false,cn="GET",dk=cn,aM="application/x-www-form-urlencoded; charset=UTF-8",cE=aM,aI=cj||"",bO="",c9="",ct="",cc=cf||"",bF="",bU="",ba,bp="",dg=["7z","aac","apk","arc","arj","asf","asx","avi","azw3","bin","csv","deb","dmg","doc","docx","epub","exe","flv","gif","gz","gzip","hqx","ibooks","jar","jpg","jpeg","js","mobi","mp2","mp3","mp4","mpg","mpeg","mov","movie","msi","msp","odb","odf","odg","ods","odt","ogg","ogv","pdf","phps","png","ppt","pptx","qt","qtm","ra","ram","rar","rpm","rtf","sea","sit","tar","tbz","tbz2","bz","bz2","tgz","torrent","txt","wav","wma","wmv","wpd","xls","xlsx","xml","z","zip"],aC=[c2],bG=[],co=[],bR=[],be=[],bQ=500,c5=true,cR,bb,bX,bV,at,cw=["pk_campaign","mtm_campaign","piwik_campaign","matomo_campaign","utm_campaign","utm_source","utm_medium"],bN=["pk_kwd","mtm_kwd","piwik_kwd","matomo_kwd","utm_term"],bq="_pk_",az="pk_vid",a5=180,c7,bw,bY=false,aN="Lax",bs=false,cY,bk,bC,cS=33955200000,cu=1800000,df=15768000000,a8=true,bL=false,bn=false,bW=false,aV=false,ch,b2={},cs={},bt={},bA=200,cA={},da={},dh={},cg=[],ck=false,cJ=false,au=false,di=false,cV=false,aS=false,bi=v(),cF=null,c8=null,aW,bI,cd=aq,bv,aQ,bH=false,cx=0,bB=["id","ses","cvar","ref"],cI=false,bJ=null,cT=[],cz=[],aB=X++,aA=false,c6=true;
if(/^https?:\/\/([a-z0-9\.\-]+\.)?paypal\.com(\/|$)/.test(bu)){bu=""}try{bp=J.title}catch(cG){bp=""}function aH(dw){if(bs){return 0}var du=new RegExp("(^|;)[ ]*"+dw+"=([^;]*)"),dv=du.exec(J.cookie);return dv?V(dv[2]):0}bJ=!aH(cU);function dp(dy,dz,dC,dB,dw,dx,dA){if(bs&&dy!==cU){return}var dv;if(dC){dv=new Date();dv.setTime(dv.getTime()+dC)}if(!dA){dA="Lax"}J.cookie=dy+"="+t(dz)+(dC?";expires="+dv.toGMTString():"")+";path="+(dB||"/")+(dw?";domain="+dw:"")+(dx?";secure":"")+";SameSite="+dA;if((!dC||dC>=0)&&aH(dy)!==String(dz)){var du="There was an error setting cookie `"+dy+"`. Please check domain and path.";ao(du)}}function b8(du){var dw,dv;du=j(du,az);for(dv=0;dv<co.length;dv++){du=j(du,co[dv])}if(bV){dw=new RegExp("#.*");return du.replace(dw,"")}return du}function b1(dw,du){var dx=s(du),dv;if(dx){return du}if(du.slice(0,1)==="/"){return s(dw)+"://"+d(dw)+du}dw=b8(dw);dv=dw.indexOf("?");if(dv>=0){dw=dw.slice(0,dv)}dv=dw.lastIndexOf("/");if(dv!==dw.length-1){dw=dw.slice(0,dv+1)}return dw+du
}function cP(dw,du){var dv;dw=String(dw).toLowerCase();du=String(du).toLowerCase();if(dw===du){return true}if(du.slice(0,1)==="."){if(dw===du.slice(1)){return true}dv=dw.length-du.length;if((dv>0)&&(dw.slice(dv)===du)){return true}}return false}function cr(du){var dv=document.createElement("a");if(du.indexOf("//")!==0&&du.indexOf("http")!==0){if(du.indexOf("*")===0){du=du.substr(1)}if(du.indexOf(".")===0){du=du.substr(1)}du="http://"+du}dv.href=w.toAbsoluteUrl(du);if(dv.pathname){return dv.pathname}return""}function a9(dv,du){if(!an(du,"/")){du="/"+du}if(!an(dv,"/")){dv="/"+dv}var dw=(du==="/"||du==="/*");if(dw){return true}if(dv===du){return true}du=String(du).toLowerCase();dv=String(dv).toLowerCase();if(U(du,"*")){du=du.slice(0,-1);dw=(!du||du==="/");if(dw){return true}if(dv===du){return true}return dv.indexOf(du)===0}if(!U(dv,"/")){dv+="/"}if(!U(du,"/")){du+="/"}return dv.indexOf(du)===0}function aw(dy,dA){var dv,du,dw,dx,dz;for(dv=0;dv<aC.length;dv++){dx=O(aC[dv]);dz=cr(aC[dv]);if(cP(dy,dx)&&a9(dA,dz)){return true
}}return false}function a1(dx){var dv,du,dw;for(dv=0;dv<aC.length;dv++){du=O(aC[dv].toLowerCase());if(dx===du){return true}if(du.slice(0,1)==="."){if(dx===du.slice(1)){return true}dw=dx.length-du.length;if((dw>0)&&(dx.slice(dw)===du)){return true}}}return false}function cv(du,dw){du=du.replace("send_image=0","send_image=1");var dv=new Image(1,1);dv.onload=function(){H=0;if(typeof dw==="function"){dw({request:du,trackerUrl:aI,success:true})}};dv.onerror=function(){if(typeof dw==="function"){dw({request:du,trackerUrl:aI,success:false})}};dv.src=aI+(aI.indexOf("?")<0?"?":"&")+du}function cM(du){if(dk==="POST"){return true}return du&&(du.length>2000||du.indexOf('{"requests"')===0)}function aP(){return"object"===typeof g&&"function"===typeof g.sendBeacon&&"function"===typeof Blob}function bc(dy,dB,dA){var dw=aP();if(!dw){return false}var dx={type:"application/x-www-form-urlencoded; charset=UTF-8"};var dC=false;var dv=aI;try{var du=new Blob([dy],dx);if(dA&&!cM(dy)){du=new Blob([],dx);dv=dv+(dv.indexOf("?")<0?"?":"&")+dy
}dC=g.sendBeacon(dv,du)}catch(dz){return false}if(dC&&typeof dB==="function"){dB({request:dy,trackerUrl:aI,success:true,isSendBeacon:true})}return dC}function de(dv,dw,du){if(!M(du)||null===du){du=true}if(m&&bc(dv,dw,du)){return}setTimeout(function(){if(m&&bc(dv,dw,du)){return}var dz;try{var dy=W.XMLHttpRequest?new W.XMLHttpRequest():W.ActiveXObject?new ActiveXObject("Microsoft.XMLHTTP"):null;dy.open("POST",aI,true);dy.onreadystatechange=function(){if(this.readyState===4&&!(this.status>=200&&this.status<300)){var dA=m&&bc(dv,dw,du);if(!dA&&du){cv(dv,dw)}else{if(typeof dw==="function"){dw({request:dv,trackerUrl:aI,success:false,xhr:this})}}}else{if(this.readyState===4&&(typeof dw==="function")){dw({request:dv,trackerUrl:aI,success:true,xhr:this})}}};dy.setRequestHeader("Content-Type",cE);dy.withCredentials=true;dy.send(dv)}catch(dx){dz=m&&bc(dv,dw,du);if(!dz&&du){cv(dv,dw)}else{if(typeof dw==="function"){dw({request:dv,trackerUrl:aI,success:false})}}}},50)}function cl(dv){var du=new Date();
var dw=du.getTime()+dv;if(!r||dw>r){r=dw}}function bg(){bi=true;cF=new Date().getTime()}function dn(){var du=new Date().getTime();return !cF||(du-cF)>bb}function aD(){if(dn()){bX()}}function a0(){if(J.visibilityState==="hidden"&&dn()){bX()}else{if(J.visibilityState==="visible"){cF=new Date().getTime()}}}function dr(){if(aS||!bb){return}aS=true;ar(W,"focus",bg);ar(W,"blur",aD);ar(W,"visibilitychange",a0);af++;u.addPlugin("HeartBeat"+af,{unload:function(){if(aS&&dn()){bX()}}})}function cK(dy){var dv=new Date();var du=dv.getTime();c8=du;if(cJ&&du<cJ){var dw=cJ-du;setTimeout(dy,dw);cl(dw+50);cJ+=50;return}if(cJ===false){var dx=800;cJ=du+dx}dy()}function aT(){if(aH(cU)){bJ=false}else{if(aH(bj)){bJ=true}}}function bM(dv,du,dw){aT();if(!bJ){cT.push(dv);return}aA=true;if(!cY&&dv){if(cI&&bJ){dv+="&consent=1"}cK(function(){if(c5&&bc(dv,dw,true)){cl(100);return}if(cM(dv)){de(dv,dw)}else{cv(dv,dw)}cl(du)})}if(!aS){dr()}}function cq(du){if(cY){return false}return(du&&du.length)}function dd(du,dy){if(!dy||dy>=du.length){return[du]
}var dv=0;var dw=du.length;var dx=[];for(dv;dv<dw;dv+=dy){dx.push(du.slice(dv,dv+dy))}return dx}function dq(dv,du){if(!cq(dv)){return}if(!bJ){cT.push(dv);return}aA=true;cK(function(){var dy=dd(dv,50);var dw=0,dx;for(dw;dw<dy.length;dw++){dx='{"requests":["?'+dy[dw].join('","?')+'"],"send_image":0}';if(c5&&bc(dx,null,false)){cl(100)}else{de(dx,null,false)}}cl(du)})}function aY(du){return bq+du+"."+cc+"."+bv}function b5(dw,dv,du){dp(dw,"",-129600000,dv,du)}function cb(){if(bs){return"0"}if(!M(W.showModalDialog)&&M(g.cookieEnabled)){return g.cookieEnabled?"1":"0"}var du=bq+"testcookie";dp(du,"1",undefined,bw,c7,bY,aN);var dv=aH(du)==="1"?"1":"0";b5(du);return dv}function bo(){bv=cd((c7||c2)+(bw||"/")).slice(0,4)}function cQ(){if(!c6){return{}}if(M(dh.res)){return dh}var dv,dx,dy={pdf:"application/pdf",qt:"video/quicktime",realp:"audio/x-pn-realaudio-plugin",wma:"application/x-mplayer2",fla:"application/x-shockwave-flash",java:"application/x-java-vm",ag:"application/x-silverlight"};if(!((new RegExp("MSIE")).test(g.userAgent))){if(g.mimeTypes&&g.mimeTypes.length){for(dv in dy){if(Object.prototype.hasOwnProperty.call(dy,dv)){dx=g.mimeTypes[dy[dv]];
dh[dv]=(dx&&dx.enabledPlugin)?"1":"0"}}}if(!((new RegExp("Edge[ /](\\d+[\\.\\d]+)")).test(g.userAgent))&&typeof navigator.javaEnabled!=="unknown"&&M(g.javaEnabled)&&g.javaEnabled()){dh.java="1"}if(!M(W.showModalDialog)&&M(g.cookieEnabled)){dh.cookie=g.cookieEnabled?"1":"0"}else{dh.cookie=cb()}}var dw=parseInt(ab.width,10);var du=parseInt(ab.height,10);dh.res=parseInt(dw,10)+"x"+parseInt(du,10);return dh}function b3(){var dv=aY("cvar"),du=aH(dv);if(du&&du.length){du=W.JSON.parse(du);if(Z(du)){return du}}return{}}function cN(){if(aV===false){aV=b3()}}function cZ(){var du=cQ();return cd((g.userAgent||"")+(g.platform||"")+W.JSON.stringify(du)+(new Date()).getTime()+Math.random()).slice(0,16)}function aF(){var du=cQ();return cd((g.userAgent||"")+(g.platform||"")+W.JSON.stringify(du)).slice(0,6)}function bl(){return Math.floor((new Date()).getTime()/1000)}function aO(){var dv=bl();var dw=aF();var du=String(dv)+dw;return du}function dc(dw){dw=String(dw);var dz=aF();var dx=dz.length;var dy=dw.substr(-1*dx,dx);
var dv=parseInt(dw.substr(0,dw.length-dx),10);if(dv&&dy&&dy===dz){var du=bl();if(a5<=0){return true}if(du>=dv&&du<=(dv+a5)){return true}}return false}function ds(du){if(!cV){return""}var dy=e(du,az);if(!dy){return""}dy=String(dy);var dw=new RegExp("^[a-zA-Z0-9]+$");if(dy.length===32&&dw.test(dy)){var dv=dy.substr(16,32);if(dc(dv)){var dx=dy.substr(0,16);return dx}}return""}function cW(){if(!bU){bU=ds(bT)}var dw=new Date(),du=Math.round(dw.getTime()/1000),dv=aY("id"),dz=aH(dv),dy,dx;if(dz){dy=dz.split(".");dy.unshift("0");if(bU.length){dy[1]=bU}return dy}if(bU.length){dx=bU}else{if("0"===cb()){dx=""}else{dx=cZ()}}dy=["1",dx,du];return dy}function a4(){var dx=cW(),dv=dx[0],dw=dx[1],du=dx[2];return{newVisitor:dv,uuid:dw,createTs:du}}function aL(){var dx=new Date(),dv=dx.getTime(),dy=a4().createTs;var du=parseInt(dy,10);var dw=(du*1000)+cS-dv;return dw}function aR(du){if(!cc){return}var dw=new Date(),dv=Math.round(dw.getTime()/1000);if(!M(du)){du=a4()}var dx=du.uuid+"."+du.createTs+".";dp(aY("id"),dx,aL(),bw,c7,bY,aN)
}function bS(){var du=aH(aY("ref"));if(du.length){try{du=W.JSON.parse(du);if(Z(du)){return du}}catch(dv){}}return["","",0,""]}function bD(dw){var dv=bq+"testcookie_domain";var du="testvalue";dp(dv,du,10000,null,dw,bY,aN);if(aH(dv)===du){b5(dv,null,dw);return true}return false}function aJ(){var dv=bs;bs=false;var du,dw;for(du=0;du<bB.length;du++){dw=aY(bB[du]);if(dw!==cU&&dw!==bj&&0!==aH(dw)){b5(dw,bw,c7)}}bs=dv}function b9(du){cc=du}function dt(dy){if(!dy||!Z(dy)){return}var dx=[];var dw;for(dw in dy){if(Object.prototype.hasOwnProperty.call(dy,dw)){dx.push(dw)}}var dz={};dx.sort();var du=dx.length;var dv;for(dv=0;dv<du;dv++){dz[dx[dv]]=dy[dx[dv]]}return dz}function ci(){dp(aY("ses"),"1",cu,bw,c7,bY,aN)}function bm(){var dx="";var dv="abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";var dw=dv.length;var du;for(du=0;du<6;du++){dx+=dv.charAt(Math.floor(Math.random()*dw))}return dx}function aE(dv){if(ct!==""){dv+=ct;bn=true;return dv}if(!h){return dv}var dw=(typeof h.timing==="object")&&h.timing?h.timing:undefined;
if(!dw){dw=(typeof h.getEntriesByType==="function")&&h.getEntriesByType("navigation")?h.getEntriesByType("navigation")[0]:undefined}if(!dw){return dv}var du="";if(dw.connectEnd&&dw.fetchStart){if(dw.connectEnd<dw.fetchStart){return dv}du+="&pf_net="+Math.round(dw.connectEnd-dw.fetchStart)}if(dw.responseStart&&dw.requestStart){if(dw.responseStart<dw.requestStart){return dv}du+="&pf_srv="+Math.round(dw.responseStart-dw.requestStart)}if(dw.responseStart&&dw.responseEnd){if(dw.responseEnd<dw.responseStart){return dv}du+="&pf_tfr="+Math.round(dw.responseEnd-dw.responseStart)}if(M(dw.domLoading)){if(dw.domInteractive&&dw.domLoading){if(dw.domInteractive<dw.domLoading){return dv}du+="&pf_dm1="+Math.round(dw.domInteractive-dw.domLoading)}}else{if(dw.domInteractive&&dw.responseEnd){if(dw.domInteractive<dw.responseEnd){return dv}du+="&pf_dm1="+Math.round(dw.domInteractive-dw.responseEnd)}}if(dw.domComplete&&dw.domInteractive){if(dw.domComplete<dw.domInteractive){return dv}du+="&pf_dm2="+Math.round(dw.domComplete-dw.domInteractive)
}if(dw.loadEventEnd&&dw.loadEventStart){if(dw.loadEventEnd<dw.loadEventStart){return dv}du+="&pf_onl="+Math.round(dw.loadEventEnd-dw.loadEventStart)}return dv+du}function dj(){var dE,dx=new Date(),dy=Math.round(dx.getTime()/1000),dJ,dw,dz=1024,dG,dA,dv=aY("ses"),dD=aY("ref"),dC=aH(dv),du=bS(),dI=ba||bT,dF,dB,dH={};dF=du[0];dB=du[1];dJ=du[2];dw=du[3];if(!dC){if(!bC||!dF.length){for(dE in cw){if(Object.prototype.hasOwnProperty.call(cw,dE)){dF=e(dI,cw[dE]);if(dF.length){break}}}for(dE in bN){if(Object.prototype.hasOwnProperty.call(bN,dE)){dB=e(dI,bN[dE]);if(dB.length){break}}}}dG=d(bu);dA=dw.length?d(dw):"";if(dG.length&&!a1(dG)&&(!bC||!dA.length||a1(dA))){dw=bu}if(dw.length||dF.length){dJ=dy;du=[dF,dB,dJ,b8(dw.slice(0,dz))];dp(dD,W.JSON.stringify(du),df,bw,c7,bY,aN)}}if(dF.length){dH._rcn=t(dF)}if(dB.length){dH._rck=t(dB)}dH._refts=dJ;if(String(dw).length){dH._ref=t(b8(dw.slice(0,dz)))}return dH}function cy(dv,dG,dH){var dF,du=new Date(),dE=aV,dA=aY("cvar"),dI=ba||bT;if(bs){aJ()}if(cY){return""
}var dB=a4();var dy=J.characterSet||J.charset;if(!dy||dy.toLowerCase()==="utf-8"){dy=null}dv+="&idsite="+cc+"&rec=1&r="+String(Math.random()).slice(2,8)+"&h="+du.getHours()+"&m="+du.getMinutes()+"&s="+du.getSeconds()+"&url="+t(b8(dI))+(bu.length?"&urlref="+t(b8(bu)):"")+(ac(bF)?"&uid="+t(bF):"")+"&_id="+dB.uuid+"&_idn="+dB.newVisitor+(dy?"&cs="+t(dy):"")+"&send_image=0";var dD=dj();for(dF in dD){if(Object.prototype.hasOwnProperty.call(dD,dF)){dv+="&"+dF+"="+dD[dF]}}var dK=cQ();for(dF in dK){if(Object.prototype.hasOwnProperty.call(dK,dF)){dv+="&"+dF+"="+dK[dF]}}var dL=[];if(dG){for(dF in dG){if(Object.prototype.hasOwnProperty.call(dG,dF)&&/^dimension\d+$/.test(dF)){var dw=dF.replace("dimension","");dL.push(parseInt(dw,10));dL.push(String(dw));dv+="&"+dF+"="+t(dG[dF]);delete dG[dF]}}}if(dG&&D(dG)){dG=null}for(dF in cA){if(Object.prototype.hasOwnProperty.call(cA,dF)){dv+="&"+dF+"="+t(cA[dF])}}for(dF in bt){if(Object.prototype.hasOwnProperty.call(bt,dF)){var dz=(-1===P(dL,dF));if(dz){dv+="&dimension"+dF+"="+t(bt[dF])
}}}if(dG){dv+="&data="+t(W.JSON.stringify(dG))}else{if(at){dv+="&data="+t(W.JSON.stringify(at))}}function dx(dM,dN){var dO=W.JSON.stringify(dM);if(dO.length>2){return"&"+dN+"="+t(dO)}return""}var dJ=dt(b2);var dC=dt(cs);dv+=dx(dJ,"cvar");dv+=dx(dC,"e_cvar");if(aV){dv+=dx(aV,"_cvar");for(dF in dE){if(Object.prototype.hasOwnProperty.call(dE,dF)){if(aV[dF][0]===""||aV[dF][1]===""){delete aV[dF]}}}if(bW){dp(dA,W.JSON.stringify(aV),cu,bw,c7,bY,aN)}}if(a8&&bL&&!bn){dv=aE(dv);bn=true}if(aQ){dv+="&pv_id="+aQ}aR(dB);ci();dv+=ag(dH,{tracker:bP,request:dv});if(c9.length){dv+="&"+c9}if(C(ch)){dv=ch(dv)}return dv}bX=function bd(){var du=new Date();du=du.getTime();if(!c8){return false}if(c8+bb<=du){bP.ping();return true}return false};function bx(dx,dw,dB,dy,du,dE){var dA="idgoal=0",dv=new Date(),dC=[],dD,dz=String(dx).length;if(dz){dA+="&ec_id="+t(dx)}dA+="&revenue="+dw;if(String(dB).length){dA+="&ec_st="+dB}if(String(dy).length){dA+="&ec_tx="+dy}if(String(du).length){dA+="&ec_sh="+du}if(String(dE).length){dA+="&ec_dt="+dE
}if(da){for(dD in da){if(Object.prototype.hasOwnProperty.call(da,dD)){if(!M(da[dD][1])){da[dD][1]=""}if(!M(da[dD][2])){da[dD][2]=""}if(!M(da[dD][3])||String(da[dD][3]).length===0){da[dD][3]=0}if(!M(da[dD][4])||String(da[dD][4]).length===0){da[dD][4]=1}dC.push(da[dD])}}dA+="&ec_items="+t(W.JSON.stringify(dC))}dA=cy(dA,at,"ecommerce");bM(dA,bQ);if(dz){da={}}}function b4(du,dy,dx,dw,dv,dz){if(String(du).length&&M(dy)){bx(du,dy,dx,dw,dv,dz)}}function bz(du){if(M(du)){bx("",du,"","","","")}}function b6(dv,dx,dw){if(!bH){aQ=bm()}var du=cy("action_name="+t(ap(dv||bp)),dx,"log");if(a8&&!bn){du=aE(du)}bM(du,bQ,dw)}function a6(dw,dv){var dx,du="(^| )(piwik[_-]"+dv+"|matomo[_-]"+dv;if(dw){for(dx=0;dx<dw.length;dx++){du+="|"+dw[dx]}}du+=")( |$)";return new RegExp(du)}function aZ(du){return(aI&&du&&0===String(du).indexOf(aI))}function cC(dy,du,dz,dv){if(aZ(du)){return 0}var dx=a6(bR,"download"),dw=a6(be,"link"),dA=new RegExp("\\.("+dg.join("|")+")([?&#]|$)","i");if(dw.test(dy)){return"link"}if(dv||dx.test(dy)||dA.test(du)){return"download"
}if(dz){return 0}return"link"}function ay(dv){var du;du=dv.parentNode;while(du!==null&&M(du)){if(ai.isLinkElement(dv)){break}dv=du;du=dv.parentNode}return dv}function dm(dz){dz=ay(dz);if(!ai.hasNodeAttribute(dz,"href")){return}if(!M(dz.href)){return}var dy=ai.getAttributeValueFromNode(dz,"href");var dv=dz.pathname||cr(dz.href);var dA=dz.hostname||d(dz.href);var dB=dA.toLowerCase();var dw=dz.href.replace(dA,dB);var dx=new RegExp("^(javascript|vbscript|jscript|mocha|livescript|ecmascript|mailto|tel):","i");if(!dx.test(dw)){var du=cC(dz.className,dw,aw(dB,dv),ai.hasNodeAttribute(dz,"download"));if(du){return{type:du,href:dw}}}}function aU(du,dv,dw,dx){var dy=w.buildInteractionRequestParams(du,dv,dw,dx);if(!dy){return}return cy(dy,null,"contentInteraction")}function bh(du,dv){if(!du||!dv){return false}var dw=w.findTargetNode(du);if(w.shouldIgnoreInteraction(dw)){return false}dw=w.findTargetNodeNoDefault(du);if(dw&&!Y(dw,dv)){return false}return true}function cB(dw,dv,dy){if(!dw){return}var du=w.findParentContentNode(dw);
if(!du){return}if(!bh(du,dw)){return}var dx=w.buildContentBlock(du);if(!dx){return}if(!dx.target&&dy){dx.target=dy}return w.buildInteractionRequestParams(dv,dx.name,dx.piece,dx.target)}function a2(dv){if(!cg||!cg.length){return false}var du,dw;for(du=0;du<cg.length;du++){dw=cg[du];if(dw&&dw.name===dv.name&&dw.piece===dv.piece&&dw.target===dv.target){return true}}return false}function a3(du){return function(dy){if(!du){return}var dw=w.findParentContentNode(du);var dv;if(dy){dv=dy.target||dy.srcElement}if(!dv){dv=du}if(!bh(dw,dv)){return}if(!dw){return false}var dz=w.findTargetNode(dw);if(!dz||w.shouldIgnoreInteraction(dz)){return false}var dx=dm(dz);if(di&&dx&&dx.type){return dx.type}return bP.trackContentInteractionNode(dv,"click")}}function b7(dw){if(!dw||!dw.length){return}var du,dv;for(du=0;du<dw.length;du++){dv=w.findTargetNode(dw[du]);if(dv&&!dv.contentInteractionTrackingSetupDone){dv.contentInteractionTrackingSetupDone=true;ar(dv,"click",a3(dv))}}}function bE(dw,dx){if(!dw||!dw.length){return[]
}var du,dv;for(du=0;du<dw.length;du++){if(a2(dw[du])){dw.splice(du,1);du--}else{cg.push(dw[du])}}if(!dw||!dw.length){return[]}b7(dx);var dy=[];for(du=0;du<dw.length;du++){dv=cy(w.buildImpressionRequestParams(dw[du].name,dw[du].piece,dw[du].target),undefined,"contentImpressions");if(dv){dy.push(dv)}}return dy}function cH(dv){var du=w.collectContent(dv);return bE(du,dv)}function bf(dv){if(!dv||!dv.length){return[]}var du;for(du=0;du<dv.length;du++){if(!w.isNodeVisible(dv[du])){dv.splice(du,1);du--}}if(!dv||!dv.length){return[]}return cH(dv)}function aK(dw,du,dv){var dx=w.buildImpressionRequestParams(dw,du,dv);return cy(dx,null,"contentImpression")}function dl(dx,dv){if(!dx){return}var du=w.findParentContentNode(dx);var dw=w.buildContentBlock(du);if(!dw){return}if(!dv){dv="Unknown"}return aU(dv,dw.name,dw.piece,dw.target)}function cX(dv,dx,du,dw){return"e_c="+t(dv)+"&e_a="+t(dx)+(M(du)?"&e_n="+t(du):"")+(M(dw)?"&e_v="+t(dw):"")+"&ca=1"}function ax(dw,dy,du,dx,dA,dz){if(!ac(dw)||!ac(dy)){ao("Error while logging event: Parameters `category` and `action` must not be empty or filled with whitespaces");
return false}var dv=cy(cX(dw,dy,du,dx),dA,"event");bM(dv,bQ,dz)}function ce(du,dx,dv,dy){var dw=cy("search="+t(du)+(dx?"&search_cat="+t(dx):"")+(M(dv)?"&search_count="+dv:""),dy,"sitesearch");bM(dw,bQ)}function c1(du,dy,dx,dw){var dv=cy("idgoal="+du+(dy?"&revenue="+dy:""),dx,"goal");bM(dv,bQ,dw)}function db(dx,du,dB,dA,dw){var dz=du+"="+t(b8(dx));var dv=cB(dw,"click",dx);if(dv){dz+="&"+dv}var dy=cy(dz,dB,"link");bM(dy,bQ,dA)}function b0(dv,du){if(dv!==""){return dv+du.charAt(0).toUpperCase()+du.slice(1)}return du}function cm(dz){var dy,du,dx=["","webkit","ms","moz"],dw;if(!bk){for(du=0;du<dx.length;du++){dw=dx[du];if(Object.prototype.hasOwnProperty.call(J,b0(dw,"hidden"))){if(J[b0(dw,"visibilityState")]==="prerender"){dy=true}break}}}if(dy){ar(J,dw+"visibilitychange",function dv(){J.removeEventListener(dw+"visibilitychange",dv,false);dz()});return}dz()}function by(){var dv=bP.getVisitorId();var du=aO();return dv+du}function cp(du){if(!du){return}if(!ai.hasNodeAttribute(du,"href")){return
}var dv=ai.getAttributeValueFromNode(du,"href");if(!dv||aZ(dv)){return}if(!bP.getVisitorId()){return}dv=j(dv,az);var dw=by();dv=I(dv,az,dw);ai.setAnyAttribute(du,"href",dv)}function br(dx){var dy=ai.getAttributeValueFromNode(dx,"href");if(!dy){return false}dy=String(dy);var dv=dy.indexOf("//")===0||dy.indexOf("http://")===0||dy.indexOf("https://")===0;if(!dv){return false}var du=dx.pathname||cr(dx.href);var dw=(dx.hostname||d(dx.href)).toLowerCase();if(aw(dw,du)){if(!cP(c2,O(dw))){return true}return false}return false}function cO(du){var dv=dm(du);if(dv&&dv.type){dv.href=p(dv.href);db(dv.href,dv.type,undefined,null,du);return}if(cV){du=ay(du);if(br(du)){cp(du)}}}function cD(){return J.all&&!J.addEventListener}function c3(du){var dw=du.which;var dv=(typeof du.button);if(!dw&&dv!=="undefined"){if(cD()){if(du.button&1){dw=1}else{if(du.button&2){dw=3}else{if(du.button&4){dw=2}}}}else{if(du.button===0||du.button==="0"){dw=1}else{if(du.button&1){dw=2}else{if(du.button&2){dw=3}}}}}return dw}function bZ(du){switch(c3(du)){case 1:return"left";
case 2:return"middle";case 3:return"right"}}function a7(du){return du.target||du.srcElement}function c4(du){return du==="A"||du==="AREA"}function aG(du){function dv(dx){var dy=a7(dx);var dz=dy.nodeName;var dw=a6(bG,"ignore");while(!c4(dz)&&dy&&dy.parentNode){dy=dy.parentNode;dz=dy.nodeName}if(dy&&c4(dz)&&!dw.test(dy.className)){return dy}}return function(dy){dy=dy||W.event;var dz=dv(dy);if(!dz){return}var dx=bZ(dy);if(dy.type==="click"){var dw=false;if(du&&dx==="middle"){dw=true}if(dz&&!dw){cO(dz)}}else{if(dy.type==="mousedown"){if(dx==="middle"&&dz){aW=dx;bI=dz}else{aW=bI=null}}else{if(dy.type==="mouseup"){if(dx===aW&&dz===bI){cO(dz)}aW=bI=null}else{if(dy.type==="contextmenu"){cO(dz)}}}}}}function av(dx,dw,du){var dv=typeof dw;if(dv==="undefined"){dw=true}ar(dx,"click",aG(dw),du);if(dw){ar(dx,"mouseup",aG(dw),du);ar(dx,"mousedown",aG(dw),du);ar(dx,"contextmenu",aG(dw),du)}}function aX(dv,dy,dz){if(ck){return true}ck=true;var dA=false;var dx,dw;function du(){dA=true}n(function(){function dB(dD){setTimeout(function(){if(!ck){return
}dA=false;dz.trackVisibleContentImpressions();dB(dD)},dD)}function dC(dD){setTimeout(function(){if(!ck){return}if(dA){dA=false;dz.trackVisibleContentImpressions()}dC(dD)},dD)}if(dv){dx=["scroll","resize"];for(dw=0;dw<dx.length;dw++){if(J.addEventListener){J.addEventListener(dx[dw],du,false)}else{W.attachEvent("on"+dx[dw],du)}}dC(100)}if(dy&&dy>0){dy=parseInt(dy,10);dB(dy)}})}var bK={enabled:true,requests:[],timeout:null,interval:2500,sendRequests:function(){var du=this.requests;this.requests=[];if(du.length===1){bM(du[0],bQ)}else{dq(du,bQ)}},canQueue:function(){return !m&&this.enabled},pushMultiple:function(dv){if(!this.canQueue()){dq(dv,bQ);return}var du;for(du=0;du<dv.length;du++){this.push(dv[du])}},push:function(du){if(!du){return}if(!this.canQueue()){bM(du,bQ);return}bK.requests.push(du);if(this.timeout){clearTimeout(this.timeout);this.timeout=null}this.timeout=setTimeout(function(){bK.timeout=null;bK.sendRequests()},bK.interval);var dv="RequestQueue"+aB;if(!Object.prototype.hasOwnProperty.call(b,dv)){b[dv]={unload:function(){if(bK.timeout){clearTimeout(bK.timeout)
}bK.sendRequests()}}}}};bo();this.hasConsent=function(){return bJ};this.getVisitorInfo=function(){if(!aH(aY("id"))){aR()}return cW()};this.getVisitorId=function(){return this.getVisitorInfo()[1]};this.getAttributionInfo=function(){return bS()};this.getAttributionCampaignName=function(){return bS()[0]};this.getAttributionCampaignKeyword=function(){return bS()[1]};this.getAttributionReferrerTimestamp=function(){return bS()[2]};this.getAttributionReferrerUrl=function(){return bS()[3]};this.setTrackerUrl=function(du){aI=du};this.getTrackerUrl=function(){return aI};this.getMatomoUrl=function(){return aa(this.getTrackerUrl(),bO)};this.getPiwikUrl=function(){return this.getMatomoUrl()};this.addTracker=function(dw,dv){if(!M(dw)||null===dw){dw=this.getTrackerUrl()}var du=new T(dw,dv);L.push(du);u.trigger("TrackerAdded",[this]);return du};this.getSiteId=function(){return cc};this.setSiteId=function(du){b9(du)};this.resetUserId=function(){bF=""};this.setUserId=function(du){if(ac(du)){bF=du}};this.setVisitorId=function(dv){var du=/[0-9A-Fa-f]{16}/g;
if(x(dv)&&du.test(dv)){bU=dv}else{ao("Invalid visitorId set"+dv)}};this.getUserId=function(){return bF};this.setCustomData=function(du,dv){if(Z(du)){at=du}else{if(!at){at={}}at[du]=dv}};this.getCustomData=function(){return at};this.setCustomRequestProcessing=function(du){ch=du};this.appendToTrackingUrl=function(du){c9=du};this.getRequest=function(du){return cy(du)};this.addPlugin=function(du,dv){b[du]=dv};this.setCustomDimension=function(du,dv){du=parseInt(du,10);if(du>0){if(!M(dv)){dv=""}if(!x(dv)){dv=String(dv)}bt[du]=dv}};this.getCustomDimension=function(du){du=parseInt(du,10);if(du>0&&Object.prototype.hasOwnProperty.call(bt,du)){return bt[du]}};this.deleteCustomDimension=function(du){du=parseInt(du,10);if(du>0){delete bt[du]}};this.setCustomVariable=function(dv,du,dy,dw){var dx;if(!M(dw)){dw="visit"}if(!M(du)){return}if(!M(dy)){dy=""}if(dv>0){du=!x(du)?String(du):du;dy=!x(dy)?String(dy):dy;dx=[du.slice(0,bA),dy.slice(0,bA)];if(dw==="visit"||dw===2){cN();aV[dv]=dx}else{if(dw==="page"||dw===3){b2[dv]=dx
}else{if(dw==="event"){cs[dv]=dx}}}}};this.getCustomVariable=function(dv,dw){var du;if(!M(dw)){dw="visit"}if(dw==="page"||dw===3){du=b2[dv]}else{if(dw==="event"){du=cs[dv]}else{if(dw==="visit"||dw===2){cN();du=aV[dv]}}}if(!M(du)||(du&&du[0]==="")){return false}return du};this.deleteCustomVariable=function(du,dv){if(this.getCustomVariable(du,dv)){this.setCustomVariable(du,"","",dv)}};this.deleteCustomVariables=function(du){if(du==="page"||du===3){b2={}}else{if(du==="event"){cs={}}else{if(du==="visit"||du===2){aV={}}}}};this.storeCustomVariablesInCookie=function(){bW=true};this.setLinkTrackingTimer=function(du){bQ=du};this.getLinkTrackingTimer=function(){return bQ};this.setDownloadExtensions=function(du){if(x(du)){du=du.split("|")}dg=du};this.addDownloadExtensions=function(dv){var du;if(x(dv)){dv=dv.split("|")}for(du=0;du<dv.length;du++){dg.push(dv[du])}};this.removeDownloadExtensions=function(dw){var dv,du=[];if(x(dw)){dw=dw.split("|")}for(dv=0;dv<dg.length;dv++){if(P(dw,dg[dv])===-1){du.push(dg[dv])
}}dg=du};this.setDomains=function(du){aC=x(du)?[du]:du;var dy=false,dw=0,dv;for(dw;dw<aC.length;dw++){dv=String(aC[dw]);if(cP(c2,O(dv))){dy=true;break}var dx=cr(dv);if(dx&&dx!=="/"&&dx!=="/*"){dy=true;break}}if(!dy){aC.push(c2)}};this.enableCrossDomainLinking=function(){cV=true};this.disableCrossDomainLinking=function(){cV=false};this.isCrossDomainLinkingEnabled=function(){return cV};this.setCrossDomainLinkingTimeout=function(du){a5=du};this.getCrossDomainLinkingUrlParameter=function(){return t(az)+"="+t(by())};this.setIgnoreClasses=function(du){bG=x(du)?[du]:du};this.setRequestMethod=function(du){if(du){dk=String(du).toUpperCase()}else{dk=cn}if(dk==="GET"){this.disableAlwaysUseSendBeacon()}};this.setRequestContentType=function(du){cE=du||aM};this.setGenerationTimeMs=function(du){ao("setGenerationTimeMs is no longer supported since Matomo 4. The call will be ignored. The replacement is setPagePerformanceTiming.")};this.setPagePerformanceTiming=function(dy,dA,dz,dv,dB,dw){var dx={pf_net:dy,pf_srv:dA,pf_tfr:dz,pf_dm1:dv,pf_dm2:dB,pf_onl:dw};
try{dx=Q(dx,M);dx=B(dx);ct=l(dx);if(ct===""){ao("setPagePerformanceTiming() called without parameters. This function needs to be called with at least one performance parameter.");return}bn=false;bL=true}catch(du){ao("setPagePerformanceTiming: "+du.toString())}};this.setReferrerUrl=function(du){bu=du};this.setCustomUrl=function(du){ba=b1(bT,du)};this.getCurrentUrl=function(){return ba||bT};this.setDocumentTitle=function(du){bp=du};this.setPageViewId=function(du){aQ=du;bH=true};this.setAPIUrl=function(du){bO=du};this.setDownloadClasses=function(du){bR=x(du)?[du]:du};this.setLinkClasses=function(du){be=x(du)?[du]:du};this.setCampaignNameKey=function(du){cw=x(du)?[du]:du};this.setCampaignKeywordKey=function(du){bN=x(du)?[du]:du};this.discardHashTag=function(du){bV=du};this.setCookieNamePrefix=function(du){bq=du;if(aV){aV=b3()}};this.setCookieDomain=function(du){var dv=O(du);if(!bs&&!bD(dv)){ao("Can't write cookie on domain "+du)}else{c7=dv;bo()}};this.setExcludedQueryParams=function(du){co=x(du)?[du]:du
};this.getCookieDomain=function(){return c7};this.hasCookies=function(){return"1"===cb()};this.setSessionCookie=function(dw,dv,du){if(!dw){throw new Error("Missing cookie name")}if(!M(du)){du=cu}bB.push(dw);dp(aY(dw),dv,du,bw,c7,bY,aN)};this.getCookie=function(dv){var du=aH(aY(dv));if(du===0){return null}return du};this.setCookiePath=function(du){bw=du;bo()};this.getCookiePath=function(du){return bw};this.setVisitorCookieTimeout=function(du){cS=du*1000};this.setSessionCookieTimeout=function(du){cu=du*1000};this.getSessionCookieTimeout=function(){return cu};this.setReferralCookieTimeout=function(du){df=du*1000};this.setConversionAttributionFirstReferrer=function(du){bC=du};this.setSecureCookie=function(du){if(du&&location.protocol!=="https:"){ao("Error in setSecureCookie: You cannot use `Secure` on http.");return}bY=du};this.setCookieSameSite=function(du){du=String(du);du=du.charAt(0).toUpperCase()+du.toLowerCase().slice(1);if(du!=="None"&&du!=="Lax"&&du!=="Strict"){ao("Ignored value for sameSite. Please use either Lax, None, or Strict.");
return}if(du==="None"){if(location.protocol==="https:"){this.setSecureCookie(true)}else{ao("sameSite=None cannot be used on http, reverted to sameSite=Lax.");du="Lax"}}aN=du};this.disableCookies=function(){bs=true;if(cc){aJ()}};this.areCookiesEnabled=function(){return !bs};this.setCookieConsentGiven=function(){if(bs&&!cY){bs=false;c6=true;if(cc&&aA){aR();var du=cy("ping=1",null,"ping");bM(du,bQ)}}};this.requireCookieConsent=function(){if(this.getRememberedCookieConsent()){return false}this.disableCookies();return true};this.getRememberedCookieConsent=function(){return aH(cL)};this.forgetCookieConsentGiven=function(){b5(cL,bw,c7);this.disableCookies()};this.rememberCookieConsentGiven=function(dv){if(dv){dv=dv*60*60*1000}else{dv=30*365*24*60*60*1000}this.setCookieConsentGiven();var du=new Date().getTime();dp(cL,du,dv,bw,c7,bY,aN)};this.deleteCookies=function(){aJ()};this.setDoNotTrack=function(dv){var du=g.doNotTrack||g.msDoNotTrack;cY=dv&&(du==="yes"||du==="1");if(cY){this.disableCookies()
}};this.alwaysUseSendBeacon=function(){c5=true};this.disableAlwaysUseSendBeacon=function(){c5=false};this.addListener=function(dv,du){av(dv,du,false)};this.enableLinkTracking=function(dv){if(di){return}di=true;var du=this;q(function(){au=true;var dw=J.body;av(dw,dv,true)})};this.enableJSErrorTracking=function(){if(c0){return}c0=true;var du=W.onerror;W.onerror=function(dz,dx,dw,dy,dv){cm(function(){var dA="JavaScript Errors";var dB=dx+":"+dw;if(dy){dB+=":"+dy}if(P(cz,dA+dB+dz)===-1){cz.push(dA+dB+dz);ax(dA,dB,dz)}});if(du){return du(dz,dx,dw,dy,dv)}return false}};this.disablePerformanceTracking=function(){a8=false};this.enableHeartBeatTimer=function(du){du=Math.max(du||15,5);bb=du*1000;if(c8!==null){dr()}};this.disableHeartBeatTimer=function(){if(bb||aS){if(W.removeEventListener){W.removeEventListener("focus",bg);W.removeEventListener("blur",aD);W.removeEventListener("visibilitychange",a0)}else{if(W.detachEvent){W.detachEvent("onfocus",bg);W.detachEvent("onblur",aD);W.detachEvent("visibilitychange",a0)
}}}bb=null;aS=false};this.killFrame=function(){if(W.location!==W.top.location){W.top.location=W.location}};this.redirectFile=function(du){if(W.location.protocol==="file:"){W.location=du}};this.setCountPreRendered=function(du){bk=du};this.trackGoal=function(du,dx,dw,dv){cm(function(){c1(du,dx,dw,dv)})};this.trackLink=function(dv,du,dx,dw){cm(function(){db(dv,du,dx,dw)})};this.getNumTrackedPageViews=function(){return cx};this.trackPageView=function(du,dw,dv){cg=[];cT=[];cz=[];if(R(cc)){cm(function(){ad(aI,bO,cc)})}else{cm(function(){cx++;b6(du,dw,dv)})}};this.disableBrowserFeatureDetection=function(){c6=false};this.enableBrowserFeatureDetection=function(){c6=true};this.trackAllContentImpressions=function(){if(R(cc)){return}cm(function(){q(function(){var du=w.findContentNodes();var dv=cH(du);bK.pushMultiple(dv)})})};this.trackVisibleContentImpressions=function(du,dv){if(R(cc)){return}if(!M(du)){du=true}if(!M(dv)){dv=750}aX(du,dv,this);cm(function(){n(function(){var dw=w.findContentNodes();
var dx=bf(dw);bK.pushMultiple(dx)})})};this.trackContentImpression=function(dw,du,dv){if(R(cc)){return}dw=a(dw);du=a(du);dv=a(dv);if(!dw){return}du=du||"Unknown";cm(function(){var dx=aK(dw,du,dv);bK.push(dx)})};this.trackContentImpressionsWithinNode=function(du){if(R(cc)||!du){return}cm(function(){if(ck){n(function(){var dv=w.findContentNodesWithinNode(du);var dw=bf(dv);bK.pushMultiple(dw)})}else{q(function(){var dv=w.findContentNodesWithinNode(du);var dw=cH(dv);bK.pushMultiple(dw)})}})};this.trackContentInteraction=function(dw,dx,du,dv){if(R(cc)){return}dw=a(dw);dx=a(dx);du=a(du);dv=a(dv);if(!dw||!dx){return}du=du||"Unknown";cm(function(){var dy=aU(dw,dx,du,dv);if(dy){bK.push(dy)}})};this.trackContentInteractionNode=function(dw,dv){if(R(cc)||!dw){return}var du=null;cm(function(){du=dl(dw,dv);if(du){bK.push(du)}});return du};this.logAllContentBlocksOnPage=function(){var dw=w.findContentNodes();var du=w.collectContent(dw);var dv=typeof console;if(dv!=="undefined"&&console&&console.log){console.log(du)
}};this.trackEvent=function(dv,dx,du,dw,dz,dy){cm(function(){ax(dv,dx,du,dw,dz,dy)})};this.trackSiteSearch=function(du,dw,dv,dx){cg=[];cm(function(){ce(du,dw,dv,dx)})};this.setEcommerceView=function(dy,du,dw,dv){cA={};if(ac(dw)){dw=String(dw)}if(!M(dw)||dw===null||dw===false||!dw.length){dw=""}else{if(dw instanceof Array){dw=W.JSON.stringify(dw)}}var dx="_pkc";cA[dx]=dw;if(M(dv)&&dv!==null&&dv!==false&&String(dv).length){dx="_pkp";cA[dx]=dv}if(!ac(dy)&&!ac(du)){return}if(ac(dy)){dx="_pks";cA[dx]=dy}if(!ac(du)){du=""}dx="_pkn";cA[dx]=du};this.getEcommerceItems=function(){return JSON.parse(JSON.stringify(da))};this.addEcommerceItem=function(dy,du,dw,dv,dx){if(ac(dy)){da[dy]=[String(dy),du,dw,dv,dx]}};this.removeEcommerceItem=function(du){if(ac(du)){du=String(du);delete da[du]}};this.clearEcommerceCart=function(){da={}};this.trackEcommerceOrder=function(du,dy,dx,dw,dv,dz){b4(du,dy,dx,dw,dv,dz)};this.trackEcommerceCartUpdate=function(du){bz(du)};this.trackRequest=function(dv,dx,dw,du){cm(function(){var dy=cy(dv,dx,du);
bM(dy,bQ,dw)})};this.ping=function(){this.trackRequest("ping=1",null,null,"ping")};this.disableQueueRequest=function(){bK.enabled=false};this.setRequestQueueInterval=function(du){if(du<1000){throw new Error("Request queue interval needs to be at least 1000ms")}bK.interval=du};this.queueRequest=function(du){cm(function(){var dv=cy(du);bK.push(dv)})};this.isConsentRequired=function(){return cI};this.getRememberedConsent=function(){var du=aH(bj);if(aH(cU)){if(du){b5(bj,bw,c7)}return null}if(!du||du===0){return null}return du};this.hasRememberedConsent=function(){return !!this.getRememberedConsent()};this.requireConsent=function(){cI=true;bJ=this.hasRememberedConsent();if(!bJ){bs=true}y++;b["CoreConsent"+y]={unload:function(){if(!bJ){aJ()}}}};this.setConsentGiven=function(dv){bJ=true;c6=true;b5(cU,bw,c7);var dw,du;for(dw=0;dw<cT.length;dw++){du=typeof cT[dw];if(du==="string"){bM(cT[dw],bQ)}else{if(du==="object"){dq(cT[dw],bQ)}}}cT=[];if(!M(dv)||dv){this.setCookieConsentGiven()}};this.rememberConsentGiven=function(dw){if(dw){dw=dw*60*60*1000
}else{dw=30*365*24*60*60*1000}var du=true;this.setConsentGiven(du);var dv=new Date().getTime();dp(bj,dv,dw,bw,c7,bY,aN)};this.forgetConsentGiven=function(){var du=30*365*24*60*60*1000;b5(bj,bw,c7);dp(cU,new Date().getTime(),du,bw,c7,bY,aN);this.forgetCookieConsentGiven();this.requireConsent()};this.isUserOptedOut=function(){return !bJ};this.optUserOut=this.forgetConsentGiven;this.forgetUserOptOut=function(){this.setConsentGiven(false)};n(function(){setTimeout(function(){bL=true},0)});u.trigger("TrackerSetup",[this]);u.addPlugin("TrackerVisitorIdCookie"+aB,{unload:function(){if(!aA){aR();dj()}}})}function K(){return{push:aj}}function c(ay,ax){var az={};var av,aw;for(av=0;av<ax.length;av++){var at=ax[av];az[at]=1;for(aw=0;aw<ay.length;aw++){if(ay[aw]&&ay[aw][0]){var au=ay[aw][0];if(at===au){aj(ay[aw]);delete ay[aw];if(az[au]>1&&au!=="addTracker"&&au!=="enableLinkTracking"){ao("The method "+au+' is registered more than once in "_paq" variable. Only the last call has an effect. Please have a look at the multiple Matomo trackers documentation: https://developer.matomo.org/guides/tracking-javascript-guide#multiple-piwik-trackers')
}az[au]++}}}}return ay}var E=["addTracker","forgetCookieConsentGiven","requireCookieConsent","disableBrowserFeatureDetection","disableCookies","setTrackerUrl","setAPIUrl","enableCrossDomainLinking","setCrossDomainLinkingTimeout","setSessionCookieTimeout","setVisitorCookieTimeout","setCookieNamePrefix","setCookieSameSite","setSecureCookie","setCookiePath","setCookieDomain","setDomains","setUserId","setVisitorId","setSiteId","alwaysUseSendBeacon","disableAlwaysUseSendBeacon","enableLinkTracking","setCookieConsentGiven","requireConsent","setConsentGiven","disablePerformanceTracking","setPagePerformanceTiming","setExcludedQueryParams"];function ah(av,au){var at=new T(av,au);L.push(at);_paq=c(_paq,E);for(H=0;H<_paq.length;H++){if(_paq[H]){aj(_paq[H])}}_paq=new K();u.trigger("TrackerAdded",[at]);return at}ar(W,"beforeunload",am,false);ar(W,"visibilitychange",function(){if(m){return}if(J.visibilityState==="hidden"){ag("unload")}},false);ar(W,"online",function(){if(M(g.serviceWorker)){g.serviceWorker.ready.then(function(at){if(at&&at.sync){return at.sync.register("matomoSync")
}},function(){})}},false);ar(W,"message",function(ay){if(!ay||!ay.origin){return}var aA,aw,au;var aB=d(ay.origin);var ax=u.getAsyncTrackers();for(aw=0;aw<ax.length;aw++){au=d(ax[aw].getMatomoUrl());if(au===aB){aA=ax[aw];break}}if(!aA){return}var av=null;try{av=JSON.parse(ay.data)}catch(az){return}if(!av){return}function at(aE){var aG=J.getElementsByTagName("iframe");for(aw=0;aw<aG.length;aw++){var aF=aG[aw];var aC=d(aF.src);if(aF.contentWindow&&M(aF.contentWindow.postMessage)&&aC===aB){var aD=JSON.stringify(aE);aF.contentWindow.postMessage(aD,"*")}}}if(M(av.maq_initial_value)){at({maq_opted_in:av.maq_initial_value&&aA.hasConsent(),maq_url:aA.getMatomoUrl(),maq_optout_by_default:aA.isConsentRequired()})}else{if(M(av.maq_opted_in)){ax=u.getAsyncTrackers();for(aw=0;aw<ax.length;aw++){aA=ax[aw];if(av.maq_opted_in){aA.rememberConsentGiven()}else{aA.forgetConsentGiven()}}at({maq_confirm_opted_in:aA.hasConsent(),maq_url:aA.getMatomoUrl(),maq_optout_by_default:aA.isConsentRequired()})}}},false);
Date.prototype.getTimeAlias=Date.prototype.getTime;u={initialized:false,JSON:W.JSON,DOM:{addEventListener:function(aw,av,au,at){var ax=typeof at;if(ax==="undefined"){at=false}ar(aw,av,au,at)},onLoad:n,onReady:q,isNodeVisible:i,isOrWasNodeVisible:w.isNodeVisible},on:function(au,at){if(!z[au]){z[au]=[]}z[au].push(at)},off:function(av,au){if(!z[av]){return}var at=0;for(at;at<z[av].length;at++){if(z[av][at]===au){z[av].splice(at,1)}}},trigger:function(av,aw,au){if(!z[av]){return}var at=0;for(at;at<z[av].length;at++){z[av][at].apply(au||W,aw)}},addPlugin:function(at,au){b[at]=au},getTracker:function(au,at){if(!M(at)){at=this.getAsyncTracker().getSiteId()}if(!M(au)){au=this.getAsyncTracker().getTrackerUrl()}return new T(au,at)},getAsyncTrackers:function(){return L},addTracker:function(av,au){var at;if(!L.length){at=ah(av,au)}else{at=L[0].addTracker(av,au)}return at},getAsyncTracker:function(ax,aw){var av;if(L&&L.length&&L[0]){av=L[0]}else{return ah(ax,aw)}if(!aw&&!ax){return av}if((!M(aw)||null===aw)&&av){aw=av.getSiteId()
}if((!M(ax)||null===ax)&&av){ax=av.getTrackerUrl()}var au,at=0;for(at;at<L.length;at++){au=L[at];if(au&&String(au.getSiteId())===String(aw)&&au.getTrackerUrl()===ax){return au}}},retryMissedPluginCalls:function(){var au=al;al=[];var at=0;for(at;at<au.length;at++){aj(au[at])}}};if(typeof define==="function"&&define.amd){define("piwik",[],function(){return u});define("matomo",[],function(){return u})}return u}())}
/*!!! pluginTrackerHook */
(function(){function b(){if("object"!==typeof _paq){return false}var c=typeof _paq.length;if("undefined"===c){return false}return !!_paq.length}if(window&&"object"===typeof window.matomoPluginAsyncInit&&window.matomoPluginAsyncInit.length){var a=0;for(a;a<window.matomoPluginAsyncInit.length;a++){if(typeof window.matomoPluginAsyncInit[a]==="function"){window.matomoPluginAsyncInit[a]()}}}if(window&&window.piwikAsyncInit){window.piwikAsyncInit()}if(window&&window.matomoAsyncInit){window.matomoAsyncInit()}if(!window.Matomo.getAsyncTrackers().length){if(b()){window.Matomo.addTracker()
}else{_paq={push:function(c){var d=typeof console;if(d!=="undefined"&&console&&console.error){console.error("_paq.push() was used but Matomo tracker was not initialized before the matomo.js file was loaded. Make sure to configure the tracker via _paq.push before loading matomo.js. Alternatively, you can create a tracker via Matomo.addTracker() manually and then use _paq.push but it may not fully work as tracker methods may not be executed in the correct order.",c)}}}}}window.Matomo.trigger("MatomoInitialized",[]);window.Matomo.initialized=true}());(function(){var a=(typeof window.AnalyticsTracker);if(a==="undefined"){window.AnalyticsTracker=window.Matomo}}());if(typeof window.piwik_log!=="function"){window.piwik_log=function(c,e,g,f){function b(h){try{if(window["piwik_"+h]){return window["piwik_"+h]}}catch(i){}return}var d,a=window.Matomo.getTracker(g,e);a.setDocumentTitle(c);a.setCustomData(f);d=b("tracker_pause");if(d){a.setLinkTrackingTimer(d)}d=b("download_extensions");if(d){a.setDownloadExtensions(d)
}d=b("hosts_alias");if(d){a.setDomains(d)}d=b("ignore_classes");if(d){a.setIgnoreClasses(d)}a.trackPageView();if(b("install_tracker")){piwik_track=function(i,j,k,h){a.setSiteId(j);a.setTrackerUrl(k);a.trackLink(i,h)};a.enableLinkTracking()}}}
/*!! @license-end */;libAvailable=typeof window.Piwik!=='undefined'||typeof window.Matomo!=='undefined';libLoaded=libAvailable;}
function loadTracker(url,jsEndpoint){if(checkLoadedAlready()){return;}
if(!libLoaded){libLoaded=true;var d=document,g=d.createElement('script'),s=d.getElementsByTagName('script')[0];g.async=true;g.src=url+jsEndpoint;s.parentNode.insertBefore(g,s);}}
var configuredTrackers={};return function(parameters,TagManager){var lastUserId;var lastIdSite;var lastMatomoUrl;function getMatomoUrlFromConfig(matomoConfig){var matomoUrl=matomoConfig.matomoUrl;if(matomoUrl&&String(matomoUrl).substr(-1,1)!=='/'){matomoUrl+='/';}
return matomoUrl;}
this.fire=function(){callbacks.push(function(){if(!parameters.matomoConfig||!parameters.matomoConfig.name){return;}
var variableName=parameters.matomoConfig.name;var matomoConfig=parameters.get('matomoConfig',{});var tracker;if(variableName in configuredTrackers){tracker=configuredTrackers[variableName];}else{lastIdSite=matomoConfig.idSite;lastMatomoUrl=getMatomoUrlFromConfig(matomoConfig);var trackerUrl=lastMatomoUrl+matomoConfig.trackingEndpoint;if(matomoConfig.registerAsDefaultTracker){tracker=Piwik.addTracker(trackerUrl,matomoConfig.idSite);}else{tracker=Piwik.getTracker(trackerUrl,matomoConfig.idSite);}
configuredTrackers[variableName]=tracker;if(matomoConfig.requireCookieConsent){tracker.requireCookieConsent();}
if(matomoConfig.disableBrowserFeatureDetection&&typeof tracker.disableBrowserFeatureDetection==='function'){tracker.disableBrowserFeatureDetection();}
if(matomoConfig.disableCookies){tracker.disableCookies();}
if(matomoConfig.enableCrossDomainLinking){tracker.enableCrossDomainLinking();}
if(matomoConfig.cookieSameSite){tracker.setCookieSameSite(matomoConfig.cookieSameSite);}
if(matomoConfig.setSecureCookie){tracker.setSecureCookie(true);}
if(matomoConfig.cookiePath){tracker.setCookiePath(matomoConfig.cookiePath);}
if(matomoConfig.cookieDomain){tracker.setCookieDomain(matomoConfig.cookieDomain);}
if(matomoConfig.domains&&TagManager.utils.isArray(matomoConfig.domains)&&matomoConfig.domains.length){var domains=[];var k,domainType;for(k=0;k<matomoConfig.domains.length;k++){var domainType=typeof matomoConfig.domains[k];if(domainType==='string'){domains.push(matomoConfig.domains[k]);}else if(domainType==='object'&&matomoConfig.domains[k].domain){domains.push(matomoConfig.domains[k].domain);}}
tracker.setDomains(domains);}
if(matomoConfig.alwaysUseSendBeacon){tracker.alwaysUseSendBeacon();}
if(matomoConfig.enableLinkTracking){tracker.enableLinkTracking();}
if(matomoConfig.requireConsent){tracker.requireConsent();}
if(matomoConfig.enableDoNotTrack){tracker.setDoNotTrack(1);}
if(matomoConfig.enableJSErrorTracking){tracker.enableJSErrorTracking();}
if(matomoConfig.enableHeartBeatTimer){tracker.enableHeartBeatTimer();}
if(matomoConfig.trackAllContentImpressions){tracker.trackAllContentImpressions();}
if(matomoConfig.trackVisibleContentImpressions){tracker.trackVisibleContentImpressions();}}
if((matomoConfig.userId||tracker.getUserId())&&lastUserId!==matomoConfig.userId){tracker.setUserId(matomoConfig.userId);lastUserId=matomoConfig.userId;}
if(matomoConfig.idSite&&lastIdSite!==matomoConfig.idSite){tracker.setSiteId(matomoConfig.idSite);lastIdSite=matomoConfig.idSite;}
var possiblyUpdatedMatomoUrl=getMatomoUrlFromConfig(matomoConfig);if(possiblyUpdatedMatomoUrl&&lastMatomoUrl!==possiblyUpdatedMatomoUrl){tracker.setTrackerUrl(possiblyUpdatedMatomoUrl+matomoConfig.trackingEndpoint);lastIdSite=possiblyUpdatedMatomoUrl;}
if(matomoConfig.customDimensions&&TagManager.utils.isArray(matomoConfig.customDimensions)&&matomoConfig.customDimensions.length){var dimIndex;for(dimIndex=0;dimIndex<matomoConfig.customDimensions.length;dimIndex++){var dimension=matomoConfig.customDimensions[dimIndex];if(dimension&&TagManager.utils.isObject(dimension)&&dimension.index&&dimension.hasOwnProperty('value')){tracker.setCustomDimension(dimension.index,dimension.value);}}}
if(tracker){var trackingType=parameters.get('trackingType');if(trackingType==='pageview'){var customTitle=parameters.get('documentTitle');if(customTitle){tracker.setDocumentTitle(customTitle);}
var customUrl=parameters.get('customUrl');if(customUrl){tracker.setCustomUrl(customUrl);}
tracker.trackPageView();}else if(trackingType==='event'){tracker.trackEvent(parameters.get('eventCategory'),parameters.get('eventAction'),parameters.get('eventName'),parameters.get('eventValue'));}else if(trackingType==='goal'){tracker.trackGoal(parameters.get('idGoal'));}}});var matomoConfig=parameters.get('matomoConfig',{});if(matomoConfig.bundleTracker){loadMatomo();}
if(!matomoConfig.matomoUrl||!matomoConfig.idSite){return;}
var matomoUrl=getMatomoUrlFromConfig(matomoConfig);loadTracker(matomoUrl,matomoConfig.jsEndpoint);};};})(); 
Templates['MatomoConfigurationVariable'] = (function(){return function(parameters,TagManager){this.get=function(){var config={};for(var i in parameters){if(i==='document'||i==='window'||i==='container'||i==='variable'||TagManager.utils.isFunction(parameters[i])){continue;}
if(TagManager.utils.hasProperty(parameters,i)){config[i]=parameters.get(i);}}
return config;};this.toString=function(){return'';};};})(); 
Templates['FacebookPixelTag'] = (function(){return function(parameters,TagManager){var setup={};var isLibLoaded=false;this.fire=function(){if(!isLibLoaded){isLibLoaded=true;!function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(parameters.window,parameters.document,'script','https://connect.facebook.net/en_US/fbevents.js');}
var pixelId=parameters.get('pixelId');if(!(pixelId in setup)){setup[pixelId]=true;fbq('init',pixelId);}
fbq('track','PageView');};};})(); 
Templates['CustomHtmlTag'] = (function(){/*!
    * secure-filters from https://github.com/salesforce/secure-filters/blob/master/lib/secure-filters.js
    * license: BSD-3-Clause https://github.com/salesforce/secure-filters/blob/master/LICENSE.txt
    * */
function convertControlCharacters(str){return String(str).replace(/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x9F]/g,' ');};var secureFilters={};secureFilters.css=function(val){var str=String(val);str=convertControlCharacters(str);return str.replace(/[^a-zA-Z0-9\uD800-\uDFFF]/g,function(match){var code=match.charCodeAt(0);if(code===0){return'\\fffd ';}else{var hex=code.toString(16).toLowerCase();return'\\'+hex+' ';}});};secureFilters.html=function(val){var str=String(val);str=convertControlCharacters(str);return str.replace(/[^\t\n\v\f\r ,\.0-9A-Z_a-z\-\u00A0-\uFFFF]/g,function(match){var code=match.charCodeAt(0);switch(code){case 0x22:return'&quot;';case 0x26:return'&amp;';case 0x3C:return'&lt;';case 0x3E:return'&gt;';default:if(code<100){var dec=code.toString(10);return'&#'+dec+';';}else{var hex=code.toString(16).toUpperCase();return'&#x'+hex+';';}}});};secureFilters.style=function(val){return secureFilters.html(secureFilters.css(val));};secureFilters.uri=function(val){var QUOT=/\x22/g;var APOS=/\x27/g;var AST=/\*/g;var TILDE=/~/g;var BANG=/!/g;var LPAREN=/\(/g;var RPAREN=/\)/g;var encode=encodeURI(String(val));return encode.replace(BANG,'%21').replace(QUOT,'%27').replace(APOS,'%27').replace(LPAREN,'%28').replace(RPAREN,'%29').replace(AST,'%2A').replace(TILDE,'%7E');};/*! end secure filters */
return function(parameters,TagManager){function moveChildrenToArray(element){var children=[];var j=0;while(j in element.childNodes&&element.childNodes.length){children.push(element.removeChild(element.childNodes[j]));}
return children;}
function cloneScript(element){var newScript=parameters.document.createElement('script');var src=TagManager.dom.getElementAttribute(element,'src');if(src){newScript.setAttribute('src',src);}else{newScript.text=element.text||element.textContent||element.innerHTML||'';}
if(element.hasAttribute('id')){newScript.setAttribute('id',element.getAttribute('id'));}
if(element.hasAttribute('charset')){newScript.setAttribute('charset',element.getAttribute('charset'));}
if(element.hasAttribute('defer')){newScript.setAttribute('defer',element.getAttribute('defer'));}
if(element.hasAttribute('async')){newScript.setAttribute('async',element.getAttribute('async'));}
if(element.hasAttribute('onload')){newScript.setAttribute('onload',element.getAttribute('onload'));}
if(element.hasAttribute('type')){newScript.setAttribute('type',element.getAttribute('type'));}
return newScript;}
function isJavaScriptElement(element){if(element&&element.nodeName&&element.nodeName.toLowerCase()==='script'){var type=TagManager.dom.getElementAttribute(element,'type');if(!type||String(type).toLowerCase()==='text/javascript'){return true;}}
return false;}
function doChildrenContainJavaScript(element){return element&&element.innerHTML&&element.innerHTML.toLowerCase().indexOf("<script")!==-1;}
function insertNode(parent,child,append,previousElement){if(append||!parent.firstChild){return parent.appendChild(child);}else{if(previousElement){return previousElement.parentNode.insertBefore(child,previousElement.nextSibling);}
return parent.insertBefore(child,parent.firstChild);}}
function moveNodes(parent,children,append){var limit=5000;var counter=0;var child;var previousElement=null;while(counter in children&&children[counter]&&counter<limit){child=children[counter];counter++;if(isJavaScriptElement(child)){previousElement=insertNode(parent,cloneScript(child),append,previousElement);}else if(doChildrenContainJavaScript(child)){var subChildren=moveChildrenToArray(child);previousElement=insertNode(parent,child,append,previousElement);moveNodes(child,subChildren);}else{previousElement=insertNode(parent,child,append,previousElement);}}}
this.fire=function(){var html=parameters.customHtml;if(html&&html.type==='JoinedVariable'){var variables=html.getDefinition();var value='',varReturn,theVarValue,isVariable,hasValueSet;for(var i=0;i<variables.length;i++){varReturn=parameters.buildVariable(variables[i]);isVariable=TagManager.utils.isObject(variables[i]);theVarValue=varReturn.get();hasValueSet=theVarValue!==false&&theVarValue!==null&&TagManager.utils.isDefined(theVarValue);if(isVariable){if(TagManager.dom.isElementContext(value,'script')){if(!TagManager.utils.isDefined(TagManager.customHtmlDataStore)){TagManager.customHtmlDataStore=[];}
TagManager.customHtmlDataStore.push(theVarValue);value+='window.MatomoTagManager.customHtmlDataStore['+(TagManager.customHtmlDataStore.length-1)+']';}else if(TagManager.dom.isElementContext(value,'style')||TagManager.dom.isAttributeContext(value,'style')){if(hasValueSet){value+=secureFilters.css(theVarValue);}else{value+='mTmKpwoqM';}}else if(TagManager.dom.isAttributeContext(value,'href')||TagManager.dom.isAttributeContext(value,'src')){if(hasValueSet){value+=secureFilters.uri(theVarValue);}}else if(hasValueSet){value+=secureFilters.html(theVarValue);}}else if(hasValueSet){value+=theVarValue;}}
html=value;}else{html=html.get();}
if(html){var div=parameters.document.createElement('div');div.innerHTML=html;if(div.childNodes){var children=moveChildrenToArray(div);var htmlPosition=parameters.get('htmlPosition','bodyEnd');var append=true;if(htmlPosition==='headStart'||htmlPosition==='bodyStart'){append=false;}
if(htmlPosition==='headStart'||htmlPosition==='headEnd'){moveNodes(parameters.document.head,children,append);}else if(parameters.document.body){moveNodes(parameters.document.body,children,append);}else{TagManager.dom.onReady(function(){moveNodes(parameters.document.body,children,append);});}}}};};})(); 
Templates['LinkedinInsightTag'] = (function(){return function(parameters,TagManager){this.fire=function(){var partnerId=parameters.get('partnerId');if(partnerId){window._linkedin_partner_id=partnerId;window._linkedin_data_partner_ids=window._linkedin_data_partner_ids||[];window._linkedin_data_partner_ids.push(window._linkedin_partner_id);(function(){var s=document.getElementsByTagName("script")[0];var b=document.createElement("script");b.type="text/javascript";b.async=true;b.src="https://snap.licdn.com/li.lms-analytics/insight.min.js";s.parentNode.insertBefore(b,s);})();}};};})(); 
Templates['PageViewTrigger'] = (function(){return function(parameters,TagManager){this.setUp=function(triggerEvent){triggerEvent({event:'mtm.PageView'});};};})(); 
Templates['PageUrlVariable'] = (function () { return function (parameters, TagManager) { this.get = function () { return parameters.window.location.href;   }; } })(); 
window.MatomoTagManager.addContainer({"id":"ySIpbG6X","idsite":115,"versionName":"24","revision":25,"environment":"live","tags":[{"id":2583,"type":"Matomo","name":"0e0129bdf61bc36b86fc6f771bf30694","parameters":{"matomoConfig":{"name":"Matomo Configuration","type":"MatomoConfiguration","lookUpTable":[],"defaultValue":"","parameters":{"matomoUrl":"https:\/\/analytics.adxl.ai\/","idSite":"115","enableLinkTracking":true,"enableCrossDomainLinking":false,"enableDoNotTrack":false,"enableJSErrorTracking":false,"enableHeartBeatTimer":false,"trackAllContentImpressions":false,"trackVisibleContentImpressions":false,"disableCookies":false,"requireConsent":false,"requireCookieConsent":false,"setSecureCookie":false,"cookieDomain":"","cookiePath":"","cookieSameSite":"Lax","disableBrowserFeatureDetection":false,"domains":[],"alwaysUseSendBeacon":false,"userId":"","customDimensions":[],"bundleTracker":true,"registerAsDefaultTracker":true,"jsEndpoint":"matomo.js","trackingEndpoint":"matomo.php"},"Variable":"MatomoConfigurationVariable"},"trackingType":"pageview","idGoal":"","documentTitle":"","customUrl":"","eventCategory":"","eventAction":"","eventName":"","eventValue":""},"blockTriggerIds":[],"fireTriggerIds":[2706],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"MatomoTag"},{"id":2584,"type":"FacebookPixel","name":"4a3b06f3eaaf47a82231755f79a08514","parameters":{"pixelId":"641893987296283"},"blockTriggerIds":[],"fireTriggerIds":[2707],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2585,"type":"FacebookPixel","name":"c8d43321dce280c5f8ffc5e65a8082a4","parameters":{"pixelId":"641893987296283"},"blockTriggerIds":[],"fireTriggerIds":[2708],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2586,"type":"FacebookPixel","name":"ec92852a01264594b5cefbced943bf9b","parameters":{"pixelId":"641893987296283"},"blockTriggerIds":[],"fireTriggerIds":[2709],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2587,"type":"CustomHtml","name":"2244ba4463b60de6897fcf2bcff89367","parameters":{"customHtml":"<script>\n fbq('track', 'ViewContent'); \n<\/script>","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2710],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2588,"type":"FacebookPixel","name":"9910bb4d27f127cdf219333f4d447ca9","parameters":{"pixelId":"641893987296283"},"blockTriggerIds":[],"fireTriggerIds":[2711],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2589,"type":"CustomHtml","name":"1ee86c1d0df76d21dbb72dccb36c698a","parameters":{"customHtml":"<script>\n fbq('track', 'ViewContent'); \n<\/script>","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2712],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2590,"type":"CustomHtml","name":"61365380d4b824642f5564e24619831b","parameters":{"customHtml":"<!-- Google tag (gtag.js) -->\n<script async src=\"https:\/\/www.googletagmanager.com\/gtag\/js?id=AW-870792055\"><\/script>\n<script>\n  window.dataLayer = window.dataLayer || [];\n  function gtag(){dataLayer.push(arguments);}\n  gtag('js', new Date());\n\n  gtag('config', 'AW-870792055');\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2713],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2591,"type":"CustomHtml","name":"7e4315e462b46193921d3a39c944e451","parameters":{"customHtml":"<!-- Event snippet for Global ADXL conversion action 1657596584717 conversion page -->\n<script>\n  gtag('event', 'conversion', {\n      'send_to': 'AW-870792055\/Q34YCL3D68wDEPf2nJ8D',\n      'value': 1.0,\n      'currency': 'AUD'\n  });\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2714],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2592,"type":"FacebookPixel","name":"37a85d913d639fbbae1b936ab9194876","parameters":{"pixelId":"641893987296283"},"blockTriggerIds":[],"fireTriggerIds":[2715],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2593,"type":"FacebookPixel","name":"f948d62d111158b81165864884e83345","parameters":{"pixelId":"641893987296283"},"blockTriggerIds":[],"fireTriggerIds":[2716],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2594,"type":"FacebookPixel","name":"c231a682be81e74f45df352e59267ad7","parameters":{"pixelId":"641893987296283"},"blockTriggerIds":[],"fireTriggerIds":[2717],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2595,"type":"FacebookPixel","name":"ba45ff4b0f8ce938c05dd08c09eecf5f","parameters":{"pixelId":"641893987296283"},"blockTriggerIds":[],"fireTriggerIds":[2718],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2596,"type":"FacebookPixel","name":"480fbf0ebea9c4f3eb55880d95816e7d","parameters":{"pixelId":"1370728906329712"},"blockTriggerIds":[],"fireTriggerIds":[2719],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2597,"type":"FacebookPixel","name":"93e7da9440805bac4a2b6988d470c0c0","parameters":{"pixelId":"1370728906329712"},"blockTriggerIds":[],"fireTriggerIds":[2720],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2598,"type":"CustomHtml","name":"7548bce64527c316f7c687739f6fc618","parameters":{"customHtml":"<!-- Google tag (gtag.js) -->\n<script async src=\"https:\/\/www.googletagmanager.com\/gtag\/js?id=AW-870792055\"><\/script>\n<script>\n  window.dataLayer = window.dataLayer || [];\n  function gtag(){dataLayer.push(arguments);}\n  gtag('js', new Date());\n\n  gtag('config', 'AW-870792055');\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2721],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2599,"type":"CustomHtml","name":"ad6003761152f61d68e1766b414d1b12","parameters":{"customHtml":"<!-- Google tag (gtag.js) -->\n<script async src=\"https:\/\/www.googletagmanager.com\/gtag\/js?id=AW-870792055\"><\/script>\n<script>\n  window.dataLayer = window.dataLayer || [];\n  function gtag(){dataLayer.push(arguments);}\n  gtag('js', new Date());\n\n  gtag('config', 'AW-870792055');\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2722],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2600,"type":"CustomHtml","name":"b7899bac66969cae12af392915aaf2d2","parameters":{"customHtml":"<!-- Event snippet for Global ADXL conversion action 1657596584717 conversion page -->\n<script>\n  gtag('event', 'conversion', {\n      'send_to': 'AW-870792055\/Q34YCL3D68wDEPf2nJ8D',\n      'value': 1.0,\n      'currency': 'AUD'\n  });\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2723],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2601,"type":"FacebookPixel","name":"d920b07066e3fe9b67abe16bdeb23564","parameters":{"pixelId":"641893987296283"},"blockTriggerIds":[],"fireTriggerIds":[2724],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2602,"type":"CustomHtml","name":"ad8196a8dd20f99a54feefedc73da9ba","parameters":{"customHtml":"<!-- Google tag (gtag.js) -->\n<script async src=\"https:\/\/www.googletagmanager.com\/gtag\/js?id=AW-870792055\"><\/script>\n<script>\n  window.dataLayer = window.dataLayer || [];\n  function gtag(){dataLayer.push(arguments);}\n  gtag('js', new Date());\n\n  gtag('config', 'AW-870792055');\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2725],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2603,"type":"CustomHtml","name":"46f87bcec2d2b05aa0aa9e36602ac2f9","parameters":{"customHtml":"<!-- Event snippet for Global ADXL conversion action 1657596584717 conversion page -->\n<script>\n  gtag('event', 'conversion', {\n      'send_to': 'AW-870792055\/Q34YCL3D68wDEPf2nJ8D',\n      'value': 1.0,\n      'currency': 'AUD'\n  });\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2726],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2604,"type":"FacebookPixel","name":"a4682d2701d7bd3709b1eed912009c52","parameters":{"pixelId":"641893987296283"},"blockTriggerIds":[],"fireTriggerIds":[2727],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2605,"type":"FacebookPixel","name":"5bb8a8982a45a3489aae746c5cb2b8ca","parameters":{"pixelId":"641893987296283"},"blockTriggerIds":[],"fireTriggerIds":[2728],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2606,"type":"CustomHtml","name":"f6088f73d8f7dbe3ec6c01029da4e47f","parameters":{"customHtml":"<!-- Google tag (gtag.js) -->\n<script async src=\"https:\/\/www.googletagmanager.com\/gtag\/js?id=AW-870792055\"><\/script>\n<script>\n  window.dataLayer = window.dataLayer || [];\n  function gtag(){dataLayer.push(arguments);}\n  gtag('js', new Date());\n\n  gtag('config', 'AW-870792055');\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2729],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2607,"type":"CustomHtml","name":"41af826871b4bb632ae1b7900ef8b71c","parameters":{"customHtml":"<!-- Event snippet for Global ADXL conversion action 1657596584717 conversion page -->\n<script>\n  gtag('event', 'conversion', {\n      'send_to': 'AW-870792055\/Q34YCL3D68wDEPf2nJ8D',\n      'value': 1.0,\n      'currency': 'AUD'\n  });\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2730],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2608,"type":"FacebookPixel","name":"c7e23a8cdf32bdf5e3a80f67519b63cb","parameters":{"pixelId":"641893987296283"},"blockTriggerIds":[],"fireTriggerIds":[2731],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2609,"type":"CustomHtml","name":"dc37c3f21e179f2cd844d0a2236305e2","parameters":{"customHtml":"<script>\n fbq('track', 'ViewContent'); \n<\/script>","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2732],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2610,"type":"FacebookPixel","name":"2edf01ff3649bda5e6574fade67a98d5","parameters":{"pixelId":"641893987296283"},"blockTriggerIds":[],"fireTriggerIds":[2733],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2611,"type":"CustomHtml","name":"255b513718e36f2eecb605569343727c","parameters":{"customHtml":"<script>\n fbq('track', 'ViewContent'); \n<\/script>","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2734],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2612,"type":"CustomHtml","name":"9d423e9251c0a1eda69d42e5a8b7faeb","parameters":{"customHtml":"<!-- Google tag (gtag.js) -->\n<script async src=\"https:\/\/www.googletagmanager.com\/gtag\/js?id=AW-870792055\"><\/script>\n<script>\n  window.dataLayer = window.dataLayer || [];\n  function gtag(){dataLayer.push(arguments);}\n  gtag('js', new Date());\n\n  gtag('config', 'AW-870792055');\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2735],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2613,"type":"CustomHtml","name":"afb79663f79c4e2a6e9f61f104f62ceb","parameters":{"customHtml":"<!-- Google tag (gtag.js) -->\n<script async src=\"https:\/\/www.googletagmanager.com\/gtag\/js?id=AW-870792055\"><\/script>\n<script>\n  window.dataLayer = window.dataLayer || [];\n  function gtag(){dataLayer.push(arguments);}\n  gtag('js', new Date());\n\n  gtag('config', 'AW-870792055');\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2736],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2614,"type":"FacebookPixel","name":"fe9b6bd5b721f290b1e955ce79258400","parameters":{"pixelId":"641893987296283"},"blockTriggerIds":[],"fireTriggerIds":[2737],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2615,"type":"CustomHtml","name":"451e2c103515ec8108770274f0d89eba","parameters":{"customHtml":"<script>\n fbq('track', 'ViewContent'); \n<\/script>","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2738],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2616,"type":"CustomHtml","name":"2ee613a5698b077cc0610727eba4e9c6","parameters":{"customHtml":"<!-- Google tag (gtag.js) -->\n<script async src=\"https:\/\/www.googletagmanager.com\/gtag\/js?id=AW-870792055\"><\/script>\n<script>\n  window.dataLayer = window.dataLayer || [];\n  function gtag(){dataLayer.push(arguments);}\n  gtag('js', new Date());\n\n  gtag('config', 'AW-870792055');\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2739],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2617,"type":"CustomHtml","name":"dc557c54d6e713ef482a5d7788b5f553","parameters":{"customHtml":"<!-- Event snippet for ADXL conversion action - complete_registration 1667111243006 conversion page -->\n<script>\n  gtag('event', 'conversion', {\n      'send_to': 'AW-870792055\/tqxwCKvj14AYEPf2nJ8D',\n      'value': 1.0,\n      'currency': 'AUD'\n  });\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2740],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2618,"type":"CustomHtml","name":"5a3fc644c754fa903a8b5013fa9add5e","parameters":{"customHtml":"<!-- Event snippet for ADXL conversion action - complete_registration 1667111201059 conversion page -->\n<script>\n  gtag('event', 'conversion', {\n      'send_to': 'AW-870792055\/rHuJCN2X2YAYEPf2nJ8D',\n      'value': 1.0,\n      'currency': 'AUD'\n  });\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2741],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2619,"type":"CustomHtml","name":"a14667263b88aa0a0d851363b521d9c8","parameters":{"customHtml":"<!-- Event snippet for ADXL conversion action - complete_registration 1667111174067 conversion page -->\n<script>\n  gtag('event', 'conversion', {\n      'send_to': 'AW-870792055\/Zo14CPCY2YAYEPf2nJ8D',\n      'value': 1.0,\n      'currency': 'AUD'\n  });\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2742],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2620,"type":"CustomHtml","name":"0af80d0d03a3ea5bb7087235e13dc062","parameters":{"customHtml":"<!-- Event snippet for Global ADXL conversion action 1657596584717 conversion page -->\n<script>\n  gtag('event', 'conversion', {\n      'send_to': 'AW-870792055\/Q34YCL3D68wDEPf2nJ8D',\n      'value': 1.0,\n      'currency': 'AUD'\n  });\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2743],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2621,"type":"LinkedinInsight","name":"a70e259fc8dafbb0b84eb4e43055f0ac","parameters":{"partnerId":"4271716"},"blockTriggerIds":[],"fireTriggerIds":[2744],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"LinkedinInsightTag"},{"id":2622,"type":"CustomHtml","name":"e8cd6baa1344e334dfe0382f4c31d092","parameters":{"customHtml":"<img height=\"1\" width=\"1\" style=\"display:none;\" alt=\"\" src=\"https:\/\/px.ads.linkedin.com\/collect\/?pid=4271716&conversionId=10019932&fmt=img\" \/>","htmlPosition":"bodyStart"},"blockTriggerIds":[],"fireTriggerIds":[2745],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2623,"type":"FacebookPixel","name":"8b066d179131f1d25050af4e44451431","parameters":{"pixelId":"641893987296283"},"blockTriggerIds":[],"fireTriggerIds":[2746],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"FacebookPixelTag"},{"id":2624,"type":"CustomHtml","name":"8ebd3ed38299736bd51cf6daa9cd4076","parameters":{"customHtml":"<script>\n fbq('track', 'ViewContent'); \n<\/script>","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2747],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2625,"type":"CustomHtml","name":"64450830d80a00eac73842e3d969111f","parameters":{"customHtml":"<script>\n fbq('track', 'ViewContent'); \n<\/script>","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2748],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2626,"type":"CustomHtml","name":"6b03fdab0fbb2e022c1dadd10cff7312","parameters":{"customHtml":"<script>\n fbq('track', 'ViewContent'); \n<\/script>","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2749],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2627,"type":"CustomHtml","name":"5b0cb9342217967f6792a67f4c73fb49","parameters":{"customHtml":"<script>\n fbq('track', 'ViewContent'); \n<\/script>","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2750],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"},{"id":2628,"type":"CustomHtml","name":"a384adac39eb7f5a90269244c288d738","parameters":{"customHtml":"<!-- Google tag (gtag.js) -->\n<script async src=\"https:\/\/www.googletagmanager.com\/gtag\/js?id=AW-870792055\"><\/script>\n<script>\n  window.dataLayer = window.dataLayer || [];\n  function gtag(){dataLayer.push(arguments);}\n  gtag('js', new Date());\n\n  gtag('config', 'AW-870792055');\n<\/script>\n","htmlPosition":"headEnd"},"blockTriggerIds":[],"fireTriggerIds":[2751],"fireLimit":"unlimited","fireDelay":0,"startDate":null,"endDate":null,"Tag":"CustomHtmlTag"}],"triggers":[{"id":2706,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2707,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2708,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2709,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2710,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2711,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2712,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2713,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2714,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2715,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2716,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2717,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2718,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2719,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2720,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2721,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2722,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2723,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2724,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2725,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2726,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2727,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2728,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2729,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2730,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2731,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2732,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"\/success"}],"Trigger":"PageViewTrigger"},{"id":2733,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2734,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"\/success"}],"Trigger":"PageViewTrigger"},{"id":2735,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2736,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2737,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2738,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2739,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2740,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2741,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2742,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2743,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2744,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2745,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2746,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"},{"id":2747,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2748,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2749,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2750,"type":"PageView","name":"PageView","parameters":[],"conditions":[{"actual":{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"},"comparison":"contains","expected":"success"}],"Trigger":"PageViewTrigger"},{"id":2751,"type":"PageView","name":"PageView","parameters":[],"conditions":[],"Trigger":"PageViewTrigger"}],"variables":[{"name":"MatomoConfiguration","type":"MatomoConfiguration","lookUpTable":[],"defaultValue":"","parameters":{"matomoUrl":"https:\/\/analytics.adxl.ai\/","idSite":"115","enableLinkTracking":true,"enableCrossDomainLinking":false,"enableDoNotTrack":false,"enableJSErrorTracking":false,"enableHeartBeatTimer":false,"trackAllContentImpressions":false,"trackVisibleContentImpressions":false,"disableCookies":false,"requireConsent":false,"requireCookieConsent":false,"setSecureCookie":false,"cookieDomain":"","cookiePath":"","cookieSameSite":"Lax","disableBrowserFeatureDetection":false,"domains":[],"alwaysUseSendBeacon":false,"userId":"","customDimensions":[],"bundleTracker":true,"registerAsDefaultTracker":true,"jsEndpoint":"matomo.js","trackingEndpoint":"matomo.php"},"Variable":"MatomoConfigurationVariable"},{"name":"PageUrl","type":"PageUrl","lookUpTable":[],"defaultValue":null,"parameters":[],"Variable":"PageUrlVariable"}]}, Templates);})()
})();
